/*--------------------------------------------------------------*/
/*  Copyright (C)   SAMSON AG (2006). All Rights Reserved       */
/*  Product:        SIEMENS SIMATIC PDM                         */
/*  Device:         SAMSON PROFIBUS Positioner 373X-4           */
/*  Communication:  PROFIBUS PA/DPV1 Profil 3.01                */
/*  Dictionary:     SIPADC01.dct                                */
/*  Description:    Device Description                          */
/*            			AO FunctionBlock and Transducer             */
/*  $Revision:   1.3  $                                         */
/*  $Date:   31 May 2005 $					                            */
/*--------------------------------------------------------------*/
/* Datum:     Autor:  Aenderungen:                              */
/* ------     ------  ------------                              */
/* 31.05.2005 Jung/E7 AO Function Block und Transducer          */
/*                    ausgelagert						                    */
/* 19.07.2005 Ald/E7  Erweitert                                 */
/* 28.04.2006 kmr/E82 erweitert						                      */
/* 08.08.2007 kmr/E82 Defaultwert trans1_manufac_actuator_size  */
/*                    auf 1 gesetzt.                            */
/* 07.05.2008 kmr/E82 MIN_VALUE trans1_manufac_actuator_size    */
/*                    auf 1 gesetzt.                            */
/*                                                              */
/*                                                              */
/*                                                              */
/*                                                              */
/*                                                              */
/*                                                              */
/*--------------------------------------------------------------*/


/******************************************************************************/
/*    Transducer Block: Actuator                                              */
/******************************************************************************/
BLOCK transducer_block_1
{
    TYPE    TRANSDUCER;
    NUMBER  1;
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_reserve
{
    LABEL       [blk_reserved];
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER(1);
    HANDLING    READ;
    HELP        [blk_reserved_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_object
{
    LABEL       [blk_block_object];
    CLASS       DEVICE;
    TYPE        ENUMERATED(1)
    {
        {   3,  [blk_block_object_TRANSDUCER]   }
    }
    HANDLING    READ;
    HELP        [blk_block_object_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_parent_class
{
    LABEL       [blk_parent_class];
    CLASS       DEVICE;
    TYPE        ENUMERATED(1)
    {
        {   5,  [trans_blk_parent_class_VALVE]  }
    }
    HANDLING    READ;
    HELP        [trans_blk_parent_class_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_class
{
    LABEL       [blk_class];
    CLASS       DEVICE;
    TYPE        ENUMERATED(1)
    {
        {   2,      [trans_act_blk_class_ELECTRO_PNEU]  },
        {   250,    [not_used]                          },
        {   251,    [none]                              },
        {   252,    [unknown]                           },
        {   253,    [special]                           }
    }
    HANDLING    READ;
    HELP        [trans_blk_class_help];
}

/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_dd_reference
{
    LABEL       [blk_dd_reference];
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER (4);
    HANDLING    READ;
    HELP        [blk_dd_reference_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_dd_rev
{
    LABEL       [blk_dd_rev];
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER(2);
    HANDLING    READ;
    HELP        [blk_dd_rev_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_profile
{
    LABEL       [blk_profile];
    CLASS       DEVICE;
    TYPE        ENUMERATED (2)
    {
        {   0x4001, [blk_profile_PA_COMPACT_A] },
        {   0x4002, [blk_profile_PA_COMPACT_B] },
        {   0x4081, [blk_profile_PA_SIMPLE_A]  },
        {   0x4082, [blk_profile_PA_SIMPLE_B]  }
    }
    HANDLING    READ;
    HELP        [blk_profile_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_profile_rev
{
    LABEL       [blk_profile_rev];
    CLASS       DEVICE;
    TYPE        ENUMERATED (2)
    {
        {   0x0301,    "3.01"   }
    }
    HANDLING    READ;
    HELP        [blk_profile_rev_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_execution_time
{
    LABEL       [blk_execution_time];
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
    HELP        [blk_execution_time_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_num_parameters
{
    LABEL       [blk_num_parameters];
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
    HELP        [blk_num_parameters_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_index_view_1
{
    LABEL       [blk_index_view_1];
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
    HELP        [blk_index_view_1_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_blk_num_view_lists
{
    LABEL       [blk_num_view_lists];
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
    HELP        [blk_num_view_lists_help];
}

/*----------------------------------------------------------------------------*/
VARIABLE trans1_st_rev
{
    LABEL       [st_rev] + " (Transducer Block)";
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
    HELP        [st_rev_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_tag_desc
{
/*    LABEL       [tag_desc];*/
    LABEL       "TAG (Transducer block)" "|de|TAG (Transducer Block)";
    CLASS       DEVICE;
    TYPE        ASCII (32)
    {
        DEFAULT_VALUE   "-/-";
    }
    HANDLING    READ & WRITE;
    HELP        [tag_desc_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_strategy
{
    LABEL       [strategy] + " (Transducer Block)";
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER (2)
    {
            DEFAULT_VALUE   0;
    }
    HANDLING    READ & WRITE;
    HELP        [strategy_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_alert_key
{
    LABEL       [alert_key] + " (Transducer Block)";
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ & WRITE;
    HELP        [alert_key_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_target_mode
{
    LABEL       [target_mode];
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
        { 0x08, [mode_AUTO]           },
        { 0x10, [mode_MAN]            },
        { 0x80, [mode_OUT_OF_SERVICE] }
    }
    HANDLING    READ & WRITE;
    HELP        [target_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_actual_mode
{
    LABEL       [actual_mode];
    CLASS       DEVICE & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        { 0x08, [mode_AUTO]           },
        { 0x10, [mode_MAN]            },
        { 0x20, [mode_LO]             },
        { 0x80, [mode_OUT_OF_SERVICE] }
    }
    HANDLING    READ;
    HELP        [actual_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_permitted_mode
{
    LABEL       [permitted_mode];
    CLASS       DEVICE;
    TYPE        BIT_ENUMERATED (1)
    {
        { 0x08, [mode_AUTO]           },
        { 0x10, [mode_MAN]            },
        { 0x80, [mode_OUT_OF_SERVICE] }
    }
    HANDLING    READ;
    HELP        [permitted_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_normal_mode
{
    LABEL       [normal_mode];
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
        { 0x08, [mode_AUTO]           },
        { 0x10, [mode_MAN]            },
        { 0x80, [mode_OUT_OF_SERVICE] }
    }
    HANDLING    READ;
    HELP        [normal_mode_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_current_state_alarm_sum
{
    LABEL       [current_state_alarm_sum];
    CLASS       DEVICE & DYNAMIC;
    TYPE        BIT_ENUMERATED (2)
    {
        {   0x0000, [limit_state_NO_ALARM]  },
        {   0x8000, [limit_state_ST_REV]    }
    }
    HANDLING    READ;
    HELP        [current_state_alarm_sum_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_unacknowledged_state_alarm_sum
{
    LABEL       [unacknowledged_state_alarm_sum];
    CLASS       DEVICE & DYNAMIC;
    TYPE        BIT_ENUMERATED (2)
    {
        {   0x0000, [limit_state_NO_ALARM]  },
        {   0x8000, [limit_state_ST_REV]    }
    }
    HANDLING    READ;
    HELP        [unacknowledged_state_alarm_sum_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_unreported_state_alarm_sum
{
    LABEL       [unreported_state_alarm_sum];
    CLASS       DEVICE & DYNAMIC;
    TYPE        BIT_ENUMERATED (2)
    {
        {   0x0000, [limit_state_NO_ALARM]  },
        {   0x8000, [limit_state_ST_REV]    }
    }
    HANDLING    READ;
    HELP        [unreported_state_alarm_sum_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_disabled_state_alarm_sum
{
    LABEL       [disabled_state_alarm_sum];
    CLASS       DEVICE & DYNAMIC;
    TYPE        BIT_ENUMERATED (2)
    {
        {   0x0000, [limit_state_NO_ALARM]  },
        {   0x8000, [limit_state_ST_REV]    }
    }
    HANDLING    READ;
    HELP        [disabled_state_alarm_sum_help];
}

/*----------------------------------------------------------------------------*/
/*    Transducer Block: Actuator ELECTRO PNEUMATIC                            */
/*----------------------------------------------------------------------------*/
VARIABLE trans1_act_stroke_time_dec
{
    LABEL "Minimum transit time close" "|de|Minimale Laufzeit zu";
    CLASS       DEVICE;
    TYPE        FLOAT
    {
            DEFAULT_VALUE   0.0;
            DISPLAY_FORMAT "3.1f";
    }
    CONSTANT_UNIT   [sec];
    HANDLING    READ;
    HELP        [trans_act_stroke_time_dec_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_act_stroke_time_inc
{
    LABEL "Minimum transit time open" "|de|Minimale Laufzeit auf";
    CLASS       DEVICE;
    TYPE        FLOAT
    {
        DEFAULT_VALUE   0.0;
        DISPLAY_FORMAT "3.1f";
    }
    CONSTANT_UNIT   [sec];
    HANDLING    READ;
    HELP        [trans_act_stroke_time_inc_help];
}

/*----------------------------------------------------------------------------*/
VARIABLE trans1_device_calib_date
{
    LABEL       [trans_act_device_calib_date];
    CLASS       DEVICE;
    TYPE        ASCII (16)
    {
        DEFAULT_VALUE   "XX.XX.20XX";
    }
    HANDLING    READ & WRITE;
    HELP        [trans_act_device_calib_date_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_device_config_date
{
    LABEL       [trans_act_device_config_date];
    CLASS       DEVICE;
    TYPE        ASCII (16)
    {
        DEFAULT_VALUE   "XX.XX.20XX";
    }
    HANDLING    READ & WRITE;
    HELP        [trans_act_device_config_date_help];
}

/* ------------------------------------------------------------------------ */
/* Parameter: Kennlinienauswahl            Doku-Nummer: 25/351  EB-Code: 20 */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_lin_type
{
    LABEL "Characteristic" "|de|Kennlinienauswahl";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
	{
	    DEFAULT_VALUE 0;
        {  0, "Linear"                                "|de|Linear"                             },
        {  1, "Equal percentage"                      "|de|Gleichprozentig"                    },
        {  2, "Equal percentage reverse"              "|de|Gleichprozentig invers"             },
        {  3, "SAMSON butterfly linear"               "|de|SAMSON Stellklappe linear"          },
        {  4, "SAMSON butterfly equal percentage"     "|de|SAMSON Stellklappe gleichprozentig" },
        {  5, "VETEC rotary linear"                   "|de|VETEC Drehkegel linear"             },
        {  6, "VETEC rotary equal percentage"         "|de|VETEC Drehkegel gleichprozentig"    },
        {  7, "Segmented ball valve linear"           "|de|Kugelsegment linear"                },
        {  8, "Segmented ball valve equal percentage" "|de|Kugelsegment gleichprozentig"       },
        {  9, "User defined"                          "|de|Benutzerdefiniert"                  }
	}
	HANDLING    READ & WRITE;
    HELP "Selection of the used characteristic."
         "|de|Auswahl der verwendeten Kennlinie.";
}


/*----------------------------------------------------------------------------*/
VARIABLE trans1_rated_travel
{
  LABEL
    IF (trans1_device_init_state == 1) /* wenn Regler initialisiert: andere Label */
    {
      "Determined nominal range" "|de|Ermittelter Nennbereich";
    }
    ELSE /* wenn Regler nicht initialisiert: andere Label */
    {
      "Required nominal range" "|de|Gewnschter Nennbereich";
    }

  CLASS DEVICE;

  HANDLING READ & WRITE;


  TYPE FLOAT
  {
    DISPLAY_FORMAT "5.1f";
    EDIT_FORMAT    "5.1f";

    /* Defaultwert von der Stiftposition abhaengig */
    /* kmr 1.9.06: bei 0 Defaultwert auf 0 gesetzt: */
    DEFAULT_VALUE
      SELECT (trans1_transm_pin_pos)
      {
        CASE 0:    0.0;
        CASE 1:    7.5;
        CASE 2:    7.5;
        CASE 3:   15.0;
        CASE 4:   30.0;
        CASE 5:   40.0;
        CASE 6:   60.0;
        CASE 8:  120.0;
        CASE 9:   90.0;
        DEFAULT:   0.0;
      }

    /* Min.- und Max.-Grenze von der Stiftposition abhaengig */
    MIN_VALUE
      SELECT (trans1_transm_pin_pos)
      {
        CASE 0:   20.0;
        CASE 1:    3.6;
        CASE 2:    5.0;
        CASE 3:    7.0;
        CASE 4:   10.0;
        CASE 5:   14.0;
        CASE 6:   20.0;
        CASE 8:   40.0;
        CASE 9:   24.0;
        DEFAULT:  20.0;
      }

    MAX_VALUE
      SELECT (trans1_transm_pin_pos)
      {
        CASE 0:  100.0;
        CASE 1:   17.7;
        CASE 2:   25.0;
        CASE 3:   35.4;
        CASE 4:   50.0;
        CASE 5:   70.7;
        CASE 6:  100.0;
        CASE 8:  200.0;
        CASE 9:  110.0;
        DEFAULT: 100.0;
      }
  }

  /* wenn Stiftposition = 9 (90) dann Einheit = , sonst mm */
  CONSTANT_UNIT
    IF (trans1_transm_pin_pos == 9)
    { ""; }
    ELSE
    { "mm"; }

  /* wenn Stiftposition = 0 (AUS) dann nicht sichtbar */
  VALIDITY
    IF (trans1_transm_pin_pos == 0)
    { FALSE; }
    ELSE
    { TRUE; }

  /* Hilfetexte fuer den ermittelten UND den gewnschten Nennbereich ! */
  HELP "The nominal travel/angle must be entered prior to initialization "
       "(initialization mode NOM or SUB). "
       "The achieved travel/angle is displayed after successful initialization."
       "|de|Fr die Initialisierung unter NOM oder SUB muss der "
       "Nennhub/-winkel des Ventiles eingegeben werden. "
       "Nach erfolgreicher Initialisierung wird hier der Hub/Winkel angezeigt, "
       "der bei der Initialisierung erreicht worden ist.";
}

/*----------------------------------------------------------------------------*/

VARIABLE trans1_self_calibration_cmd
{
  LABEL    [trans_act_self_calibration_cmd];
  CLASS    DEVICE;
  TYPE     ENUMERATED
  {
      {   0, "No test, normal operation"                         },
      {   2, "Start initialization"                              },
      {   3, "Abort initialization"                              },
      {   4, "Start zero point adjustment"                       },
      {   5, "Abort zero point adjustment"                       },
      {   6, "Search device"                                     },
      {   7, "Reset total valve travel"                          },
      /* xd_error_ext_1 */
      {  23, "Reset 'Control loop'"                              },
      {  24, "Reset 'Zero point'"                                },
      {  25, "Reset 'Autocorrection'"                            },
      {  26, "Reset 'Fatal error'"                               },
      {  28, "Reset 'x > range'"                                 },
      {  29, "Reset 'Delta x < range'"                           },
      {  30, "Reset 'Attachment'"                                },
      {  31, "Reset 'Initialization time exceeded'"              },
      {  32, "Reset 'Initialization / solenoid valve'"           },
      {  33, "Reset 'Travel time too short'"                     },
      {  34, "Reset 'Pin position'"                              },
      /* xd_error_ext_2 */
      {  40, "Reset 'x-signal'"                                  },
      {  41, "Reset 'i/p-converter'"                             },
      {  42, "Reset 'Hardware'"                                  },
      {  43, "Reset 'Control parameter'"                         },
      {  44, "Reset 'Poti parameter'"                            },
      {  45, "Reset 'Adjustment parameter'"                      },
      {  46, "Reset 'General parameter'"                         },
      {  47, "Reset 'Internal device error 1'"                   },
      {  48, "Reset 'No emergency mode'"                         },
      {  49, "Reset 'Program load error'"                        },
      {  50, "Reset 'Options parameter'"                         },
      {  51, "Reset 'Info parameter'"                            },
      {  52, "Reset 'Data memory'"                               },
      {  53, "Reset 'Control calculation'"                       },
      {  55, "Reset 'Diagnose parameter'"                        },
      /* xd_error_ext_2 */
      {  60, "Reset Counter 'Device restart'"                    },
      {  61, "Reset message 'Reset communication controller'"    },
      {  62, "Reset Counter 'Reset communication controller'"    },
      {  63, "Reset message 'Reset application controller'"      },
      {  64, "Reset Counter 'Reset application controller'"      },
      {  65, "Reset message 'Reset communication HW interface'"  },
      {  66, "Reset Counter 'Reset communication HW interface'"  }
  }
  HANDLING WRITE;
  HELP [trans_act_self_calibration_cmd_help];
}



/*----------------------------------------------------------------------------*/
VARIABLE trans1_self_calibration_status
{
    LABEL     "Status initialization" "|de|Status Initialisierung";
	CLASS	  DEVICE & DYNAMIC;
	HANDLING  READ;
	TYPE      ENUMERATED (1)
	{
        DEFAULT_VALUE 0;

        {   0, "Not active"               "|de|Nicht aktiv"                },
        {   1, "Running"                  "|de|Luft"                      },
        {  16, "Zero point adjustment"    "|de|Nullpunktabgleich"          },
        {  17, "Maximum point adjustment" "|de|Maximalpunktabgleich"       },
        {  18, "Detection of mech. stops" "|de|Ermittlung mech. Anschlge" },
        {  19, "Controller optimization"  "|de|Regleroptimierung"          },
        {  20, "Fine adjustment"          "|de|Feinabgleich"               },
        { 254, "Terminated"               "|de|Beendet"                    }
	}
    HELP "Status of the running calibration sequence."
         "|de|Status der laufenden Kalibrierung.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Prop.-faktor KP (Stufe)      Doku-Nummer: 22    EB-Code: 17   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_servo_gain_1
{
  LABEL "Proportional action coeff. KP (step)"
        "|de|Proportionalittsfaktor KP (Stufe)";

  CLASS DEVICE;
  HANDLING READ;
  TYPE        FLOAT
  {
     DISPLAY_FORMAT "2.0f";
     DEFAULT_VALUE 0;
  }
/* vorher:
  TYPE UNSIGNED_INTEGER (1)
  {
    DISPLAY_FORMAT  "2d";
    EDIT_FORMAT     "2d";

    MIN_VALUE 0;
    MAX_VALUE 17;
  }*/

  HELP "During the initialization of the positioner, KP and TV values are optimized. "
       "Should the positioner show a tendency for impermissible high post-pulse "
       "oscillation due to additional interference, KP and TV can be "
       "adapted on-site after the initialization."
       "|de|Bei der Initialisierung des Stellungsreglers werden die Werte fr "
       "KP und TV optimal eingestellt. Sollte der Regler aufgrund zustzlicher "
       "Strungen zu unzulssig hohen Nachschwingungen neigen, knnen "
       "KP und TV vor Ort angepasst werden.";
}


/* ------------------------------------------------------------------------ */
/* Parameter: Vorhaltezeit TV (Stufe)      Doku-Nummer: 23    EB-Code: 18   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_servo_rate_1
{
  LABEL "Derivative action time TV (step)" "|de|Vorhaltezeit TV (Stufe)";

  CLASS DEVICE;
  HANDLING READ;
  TYPE        FLOAT
  {
     DISPLAY_FORMAT "1.0f";
     DEFAULT_VALUE 0;
  }
/* vorher:
  TYPE ENUMERATED
  {
      { 0, "Off" "|de|Aus" },
      { 1, "1"   "|de|1"   },
      { 2, "2"   "|de|2"   },
      { 3, "3"   "|de|3"   },
      { 4, "4"   "|de|4"   }
  }*/

  HELP "During the initialization of the positioner, KP and TV values are optimized. "
       "Should the positioner show a tendency for impermissible high post-pulse "
       "oscillation due to additional interference, KP and TV can be "
       "adapted on-site after the initialization."
       "|de|Bei der Initialisierung des Stellungsreglers werden die Werte fr "
       "KP und TV optimal eingestellt. Sollte der Regler aufgrund zustzlicher "
       "Strungen zu unzulssig hohen Nachschwingungen neigen, knnen "
       "KP und TV vor Ort angepasst werden.";
}


/*----------------------------------------------------------------------------*/
VARIABLE trans1_setp_cutoff_dec
{
  LABEL "Setpoint cutoff decrease" "|de|Endlage bei w kleiner";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE 1.0;
      DISPLAY_FORMAT "4.1f";
      EDIT_FORMAT    "4.1f";

      MIN_VALUE 0.0;
      MAX_VALUE 49.9;
  }
  CONSTANT_UNIT "%";

  HELP
    SELECT (trans1_moving_direction)
    {
      CASE 1: /* steigend/steigend */
        "If w falls below the entered value, the valve is fully closed."
        "|de|Unterschreitet w diesen Wert, wird der Antrieb voll geschlossen.";
      CASE 0: /* steigend/fallend  */
        "If w exceeds the value of (100-entered value), the valve is fully closed."
        "|de|berschreitet w den Wert von (100-Wert), wird der Antrieb voll geschlossen.";
    }
}


/*----------------------------------------------------------------------------*/
VARIABLE trans1_setp_cutoff_inc
{
  LABEL "Setpoint cutoff increase" "|de|Endlage bei w grer";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE 100.0;
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE 50.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP
    SELECT (trans1_moving_direction)
    {
      CASE 1: /* steigend/steigend */
        "If w exceeds the entered value, the valve is fully opened."
        "|de|berschreitet w diesen Wert, wird der Antrieb voll geffnet.";
      CASE 0: /* steigend/fallend  */
        "If w falls below the value of (100-entered value), the valve is fully opened."
        "|de|Unterschreitet w den Wert von (100-Wert), wird der Antrieb voll geffnet.";
    }
}

/*----------------------------------------------------------------------------*/
VARIABLE trans1_total_valve_travel
{
  LABEL "Total valve travel" "|de|Wegintegral";

  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "9.0f";
      DEFAULT_VALUE 0;
  }

  HELP "Totalized double valve travel."
       "|de|Aufsummierter Ventildoppelhub.";
}

/*----------------------------------------------------------------------------*/
VARIABLE trans1_total_valve_travel_limit
{
  LABEL "Limit value total valve travel" "|de|Grenzwert Wegintegral";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE 1000000.0;
      DISPLAY_FORMAT "9.0f";
      EDIT_FORMAT    "9.0f";

      MIN_VALUE 1000.0;
      MAX_VALUE 990000000.0;
  }

  HELP "Limit value of total valve travel. If the limit value is exceeded, "
       "the fault symbol and the wrench symbol on the display appear."
       "|de|Grenzwert Wegintegral, nach dessen berschreiten erscheint die "
       "Strmeldung und das Maulschlsselsymbol auf der LC-Anzeige am Gert.";
}

/*----------------------------------------------------------------------------*/
VARIABLE trans1_travel_limit_lower_value
{
  LABEL "Travel/angle lower limit" "|de|Hub-/Drehwinkelbegrenzung unten";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE 0.0;
      DISPLAY_FORMAT "4.1f";
      EDIT_FORMAT    "4.1f";

      MIN_VALUE 0.0;
      MAX_VALUE 49.9;
  }
  CONSTANT_UNIT "%";

  HELP "Limitation of the travel/angle downwards to the entered value."
       "|de|Begrenzung des Hubes/Drehwinkels nach unten auf den "
       "eingegebenen Wert, die Kennlinie wird nicht angepasst.";
}

/*----------------------------------------------------------------------------*/
VARIABLE trans1_travel_limit_upper_value
{
  LABEL "Travel/angle upper limit" "|de|Hub-/Drehwinkelbegrenzung oben";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE 100.0;
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE 50.0;
      MAX_VALUE 120.0;
  }
  CONSTANT_UNIT "%";

  HELP "Limitation of the travel/angle upwards to the entered value."
       "|de|Begrenzung des Hubes/Drehwinkels nach oben auf den "
       "eingegebenen Wert, die Kennlinie wird nicht angepasst.";
}

/*----------------------------------------------------------------------------*/
VARIABLE trans1_travel_rate_dec
{
  LABEL "Required transit time close" "|de|Gewnschte Laufzeit zu";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE 0.0;
      DISPLAY_FORMAT "3.0f";
      EDIT_FORMAT    "3.0f";

      MIN_VALUE 0.0;
      MAX_VALUE 240.0;
  }
  CONSTANT_UNIT "s";

  HELP "The time required to pass through the working range when "
       "the valve closes."
       "|de|Zeit um den Arbeitsbereich beim Schlieen des Stellventiles "
       "zu durchfahren.";
}

/*----------------------------------------------------------------------------*/
VARIABLE trans1_travel_rate_inc
{
  LABEL "Required transit time open" "|de|Gewnschte Laufzeit auf";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE 0.0;
      DISPLAY_FORMAT "3.0f";
      EDIT_FORMAT    "3.0f";

      MIN_VALUE 0.0;
      MAX_VALUE 240.0;
  }
  CONSTANT_UNIT "s";

  HELP "The time required to pass through the working range when the valve opens."
       "|de|Zeit um den Arbeitsbereich beim ffnen des Stellventiles zu durchfahren.";
}

/*----------------------------------------------------------------------------*/
VARIABLE trans1_valve_maintenance_date
{
    LABEL       [trans_act_valve_maintenance_date];
    CLASS       DEVICE;
    TYPE        ASCII (16)
    {
        DEFAULT_VALUE   "XX.XX.20XX";
    }
    HANDLING    READ & WRITE;
    HELP        [trans_act_valve_maintenance_date_help];
}

/*----------------------------------------------------------------------------*/
VARIABLE trans1_positioning_value
{
    LABEL       [trans_act_positioning_value];
    CLASS       DEVICE & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT   ".1f";
    }
    HANDLING    READ;
    HELP        [trans_act_positioning_value_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_positioning_quality
{
    LABEL       [trans_act_positioning_status];
    CLASS       DEVICE & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        STATUS_BAD_UNCERTAIN_GOOD_MASK
    }
    HANDLING    READ;
    HELP        [trans_act_positioning_status_help];
}


trans1_positioning_limit					LIKE VARIABLE	trans1_positioning_quality
{
	REDEFINE LABEL		"Limit (Stellwert)" "|de|Limit (Stellwert)";
	REDEFINE TYPE		ENUMERATED (1)
	{
		STATUS_LIMIT
	}
  REDEFINE HELP "Contains status messages about limit violations."
                "|de|Enthlt Statusmeldungen ber Grenzwertverletzungen.";
}



/*----------------------------------------------------------------------------*/
VARIABLE trans1_feedback_value
{
    LABEL       [trans_act_feedback_value];
    CLASS       DEVICE & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT ".1f";
    }
    HANDLING    READ;
    HELP        [trans_act_feedback_value_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_feedback_quality
{
    LABEL       [trans_act_feedback_status];
    CLASS       DEVICE & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        STATUS_BAD_UNCERTAIN_GOOD_MASK
    }
    HANDLING    READ;
    HELP        [trans_act_feedback_status_help];
}

trans1_feedback_limit					LIKE VARIABLE	trans1_feedback_quality
{
	REDEFINE LABEL		"Limit (feedback)""|de|Limit (feedback)";
	REDEFINE TYPE		ENUMERATED (1)
	{
		STATUS_LIMIT
	}
  REDEFINE HELP "Contains status messages about limit violations."
                "|de|Enthlt Statusmeldungen ber Grenzwertverletzungen.";
}

/*----------------------------------------------------------------------------*/
VARIABLE trans1_valve_man
{
    LABEL       [phys_device_man_id];
    CLASS       DEVICE;
    TYPE        ASCII (16)
    {
        DEFAULT_VALUE   "SAMSON AG";
    }
    HANDLING    READ & WRITE;
    HELP        [trans_device_man_id_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE  trans1_actuator_man
{
    LABEL       [phys_device_man_id];
    CLASS       DEVICE;
    TYPE        ASCII (16)
    {
        DEFAULT_VALUE   "SAMSON AG";
    }
    HANDLING    READ & WRITE;
    HELP        [trans_device_man_id_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE  trans1_valve_type
{
//    LABEL       [phys_valve_type];
    LABEL       "Valve type" "|de|Ventilart";
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
//        {   0,  [phys_valve_type_LINEAR]        },
//        {   1,  [phys_valve_type_PART_TURN]     }
      { 0, "Linear actuator" "|de|Hubantrieb"     },
      { 1, "Rotary actuator" "|de|Schwenkantrieb" }
    }
    HANDLING    READ & WRITE;
    HELP        "Describes the valve design."
                "|de|Beschreibt die Ventilkonstruktion.";
}
/*----------------------------------------------------------------------------*/
VARIABLE  trans1_actuator_type
{
    LABEL       [phys_actuator_type];
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,  [phys_actuator_type_ELECTRO_PNEUMATIC]  },
        {   1,  [phys_actuator_type_ELECTRIC]           },
        {   2,  [phys_actuator_type_ELECTRO_HYDRAULIC]  },
        {   255,  [other]                                 }
    }
    HANDLING    READ;
    HELP        "Identifies the actuator design."
                " Parameter is determined by the actuator."
                "|de|Beschreibt die Antriebskonstruktion."
                " Parameter wird vom Antrieb bestimmt.";
}
/*----------------------------------------------------------------------------*/
VARIABLE  trans1_actuator_action
{
    LABEL       [phys_actuator_action];
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,  [phys_actuator_action_NOT_INIT]     },
        {   1,  [phys_actuator_action_OPEN]         },
        {   2,  [phys_actuator_action_CLOSE]        },
        {   3,  [phys_actuator_action_NONE]         }
    }
    HANDLING    READ;
    HELP        [phys_actuator_action_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE  trans1_valve_serial_number
{
    LABEL       [phys_serial_num];
    CLASS       DEVICE;
    TYPE        ASCII (16)
    {
        DEFAULT_VALUE   "-/-";
    }
    HANDLING    READ & WRITE;
    HELP        [phys_valve_serial_num_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE  trans1_actuator_serial_number
{
    LABEL       [trans_serial_num];
    CLASS       DEVICE;
    TYPE        ASCII (16)
    {
        DEFAULT_VALUE   "-/-";
    }
    HANDLING    READ & WRITE;
    HELP        [phys_actuator_serial_num_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_additional_gear_install_date
{
    LABEL       [trans_additional_gear_install_date];
    CLASS       DEVICE;
    TYPE        ASCII (16)
    {
       DEFAULT_VALUE    "XX.XX.20XX";
    }
    HANDLING    READ & WRITE;
    HELP        [phys_additional_gear_install_date_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE  trans1_additional_gear_ser_number
{
    LABEL       "Serial number additional component"
                "|de|Seriennummer Zusatzkomponente";
    CLASS       DEVICE;
    TYPE        ASCII (16)
    {
       DEFAULT_VALUE    "-/-";
    }
    HANDLING    READ & WRITE;
    HELP        [phys_additional_gear_serial_num_help];
}
/*----------------------------------------------------------------------------*/
VARIABLE  trans1_additional_gear_man
{
    LABEL       "Manufacturer additional component"
                "|de|Hersteller Zusatzkomponente";
    CLASS       DEVICE;
    TYPE        ASCII (16)
    {
       DEFAULT_VALUE    "-/-";
    }
    HANDLING    READ & WRITE;
    HELP        "References a specific manufacturer, which is usually a company name, "
                "that is responsible for the manufacture of this additional component."
                "|de|Kennzeichnet eindeutig den Hersteller der Zusatzkomponente. blicherweise "
                "der Name der Firma, die die entsprechende Zusatzkomponente herstellt.";
}
/*----------------------------------------------------------------------------*/
VARIABLE trans1_additional_gear_id              /* optional */
{
    LABEL       "ID additional component"
                "|de|Bezeichnung Zusatzkomponente";
    CLASS       DEVICE;
    TYPE        ASCII (16)
    {
       DEFAULT_VALUE    "-/-";
    }
    HANDLING    READ & WRITE;
    HELP        "Manufacturer specific type identification of the additional component "
                "(e.g. gearbox, booster)."
                "|de|Herstellerspezifische Bezeichnung der Zusatzkomponente (z.B. Getriebe, "
                "Booster).";
}

/******************************************************************************/
/*    Herstellerspezifische Parameter                                         */
/******************************************************************************/


/* ------------------------------------------------------------------------ */
/* Parameter: Stiftposition                Doku-Nummer: 5/352  EB-Code: 4   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_transm_pin_pos
{
  LABEL "Pin position" "|de|Stiftposition";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      { PIN_POS_OFF    , "Off"    "|de|Aus"    },
      { PIN_POS_17_MM  , "17 mm"  "|de|17 mm"  },
      { PIN_POS_25_MM  , "25 mm"  "|de|25 mm"  },
      { PIN_POS_35_MM  , "35 mm"  "|de|35 mm"  },
      { PIN_POS_50_MM  , "50 mm"  "|de|50 mm"  },
      { PIN_POS_70_MM  , "70 mm"  "|de|70 mm"  },
      { PIN_POS_100_MM , "100 mm" "|de|100 mm" },
      { PIN_POS_200_MM , "200 mm" "|de|200 mm" },
      { PIN_POS_90_GRAD, "90 "   "|de|90 "   }
  }

  HELP "The adjusted pin position is displayed, or the pin position can be "
       "selected. It must match the actual position in the lever."
       "|de|Der Abtaststift muss je nach Ventilhub/-winkel in die richtige "
       "Stiftposition eingesetzt werden. Fr die Initialisierung unter "
       "NOM oder SUB muss diese Stiftposition eingegeben werden.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Initialisierungsart          Doku-Nummer: 7     EB-Code: 6    */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_init_method
{
  LABEL "Initialization mode" "|de|Initialisierungsart";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      { INIT_ART_MAX, "Maximum range"     "|de|Maximalbereich"  },
      { INIT_ART_NOM, "Nominal range"     "|de|Nennbereich"     },
      { INIT_ART_MAN, "Manual adjustment" "|de|Handeinstellung" },
      { INIT_ART_SUB, "Substitute"        "|de|Ersetzung"       }
  }

  POST_EDIT_ACTIONS
  {
      meld_init_art    /* Methode (Text: '..erst nach Neustart wirksam') */
  }

  HELP "Selection of the initialization mode. "
       "Determines the function of the INIT key at the device, too."
       "|de|Auswahl der Initialisierungsart. "
       "Bestimmt auch die Funktion der INIT-Taste am Gert.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Ersatzabgleich durchgefuehrt  Doku-Nummer: 135   EB-Code: --  */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_sub_mode_init
{
  LABEL    "Initialized in substitution mode" "|de|Ersatzabgleich durchgefhrt";
  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
    { 0, "No"  "|de|Nein" },
    { 1, "Yes" "|de|Ja"   }
  }
  HELP "Indicates whether the substitution mode was executed."
       "|de|Anzeige ob der Ersatzabgleich (sub mode) durchgefhrt wurde.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Geraet initialisiert         Doku-Nummer: 145   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_device_init_state
{
  LABEL "Device initialized" "|de|Gert initialisiert";

  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE ENUMERATED
  {
    { 0, "No"  "|de|Nein" },
    { 1, "Yes" "|de|Ja"   }
  }

  HELP "Status of the device initialization."
       "|de|Status der Gerte - Initialisierung.";
}


/* ------------------------------------------------------------------------ */
/* Parameter: Bewegungsrichtung            Doku-Nummer: 8/347  EB-Code: 7   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_moving_direction
{
  LABEL "Moving direction" "|de|Bewegungsrichtung";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      { 0, "Increasing/increasing >>" "|de|Steigend/steigend >>" },
      { 1, "Increasing/decreasing <>" "|de|Steigend/fallend <>"  }
  }

  HELP "Operating direction of the reference variable w towards "
       "the travel/angle x."
       "|de|Bewegungsrichtung der Fhrungsgre w zum Hub/Drehwinkel x.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Schliessrichtung             Doku-Nummer: 41    EB-Code: 34   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_closing_direction
{
  LABEL "Closing direction" "|de|Schliessrichtung";

  CLASS DEVICE;
  HANDLING
    /* wenn Regler NICHT initialisiert UND Initialisierungsart = INIT_ART_SUB (Ersatzabgleich) */
    IF ((trans1_device_init_state == 0) && (trans1_init_method == INIT_ART_SUB))
    { READ&WRITE; }
    ELSE
    { READ; }

  TYPE ENUMERATED
  {
      { 0, "Clockwise"        "|de|Im Uhrzeigersinn"    },
      { 1, "Counterclockwise" "|de|Gegen Uhrzeigersinn" }
  }

  HELP "Turning direction in which the valve is moved to the closed position "
       "(view onto the rotary switch motion when the positioner cover is open). "
       "Can only be entered in initialization mode SUB."
       "|de|Drehrichtung durch die die Zu-Stellung des Stellventiles erreicht wird "
       "(Blick auf Knebelknopfbewegung bei geffnetem Deckel des Stellungsreglers). "
       "Eingabe nur bei Initialisierungsart SUB mglich.";
}


/* ------------------------------------------------------------------------ */
/* Parameter: Blockierstellung             Doku-Nummer: 42    EB-Code: 35   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_blocking_position
{
LABEL "Blocking position" "|de|Blockierstellung";

  CLASS DEVICE;
  HANDLING
    /* wenn Regler NICHT initialisiert UND Initialisierungsart = INIT_ART_SUB (Ersatzabgleich) */
    IF ((trans1_device_init_state == 0) && (trans1_init_method == INIT_ART_SUB))
    { READ&WRITE; }
    ELSE
    { READ; }

  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE 0.0;
      /* Max.-Grenze von der Stiftposition abhaengig */
      MAX_VALUE
        SELECT (trans1_transm_pin_pos)
        {
          CASE 0:  100.0;
          CASE 1:   17.7;
          CASE 2:   25.0;
          CASE 3:   35.4;
          CASE 4:   50.0;
          CASE 5:   70.7;
          CASE 6:  100.0;
          CASE 8:  200.0;
          CASE 9:  110.0;
          DEFAULT: 100.0;
        }
  }
  /* Einheit von Stiftposition abhaengig */
  CONSTANT_UNIT
      SELECT (trans1_transm_pin_pos)
      {
        CASE 0:    "%";
        CASE 1:   "mm";
        CASE 2:   "mm";
        CASE 3:   "mm";
        CASE 4:   "mm";
        CASE 5:   "mm";
        CASE 6:   "mm";
        CASE 8:   "mm";
        CASE 9:    "";
        DEFAULT:   "%";
      }

  HELP "Distance up to the closed position. Can only be entered in "
       "initialization mode SUB."
       "|de|Abstand bis zur Zu-Stellung. Nur bei Init.-modus SUB.";
}



/* ------------------------------------------------------------------------ */
/* Parameter: Aktivierung Hub-/Drehwinkelbegrenzung unten                   */
/*                                         Doku-Nummer: 11    EB-Code: 10   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_travel_lower_limit_on
{
  LABEL "Enable travel/angle lower limit"
        "|de|Aktivierung Hub-/Drehwinkelbegrenzung unten";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      { 0, "Off" "|de|Aus" },
      { 1, "On"  "|de|Ein" }
  }

  HELP "Enables the limitation of the travel/angle downwards to the entered value."
       "|de|Aktivierung der Begrenzung des Hubes/Drehwinkels nach unten.";
}



/* ------------------------------------------------------------------------ */
/* Parameter: Aktivierung Hub-/Drehwinkelbegrenzung oben
                                           Doku-Nummer: 13    EB-Code: 11   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_travel_upper_limit_on
{
  LABEL "Enable travel/angle upper limit"
        "|de|Aktivierung Hub-/Drehwinkelbegrenzung oben";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      { 0, "Off" "|de|Aus" },
      { 1, "On"  "|de|Ein" }
  }

  HELP "Enables the limitation of the travel/angle upwards to the entered value."
       "|de|Aktivierung der Begrenzung des Hubes/Drehwinkels nach oben.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Aktivierung Endlage bei w <  Doku-Nummer: 17    EB-Code: 14   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_final_value_cutoff_lo_on
{
  LABEL "Enable setpoint cutoff decrease"
        "|de|Aktivierung Endlage bei w kleiner";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      { 0, "Off" "|de|Aus" },
      { 1, "On"  "|de|Ein" }
  }

  HELP "Enables the setpoint cutoff decrease function."
       "|de|Aktivierung der Endlagenfunktion bei w kleiner.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Aktivierung Endlage bei w >  Doku-Nummer: 19    EB-Code: 15   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_final_value_cutoff_hi_on
{
  LABEL "Enable setpoint cutoff increase"
        "|de|Aktivierung Endlage bei w grer";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      { 0, "Off" "|de|Aus" },
      { 1, "On"  "|de|Ein" }
  }

  HELP "Enables the setpoint cutoff increase function."
       "|de|Aktivierung der Endlagenfunktion bei w grer.";
}

/*----------------------------------------------------------------------------*/
VARIABLE trans1_transducer_state
{
  LABEL "Operating status" "|de|Betriebszustand";

  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE ENUMERATED
  {
      {   0, "See operating mode"         "|de|Siehe Betriebsart"          },
      {   1, "Solenoid valve active"      "|de|Magnetventil aktiv"         },
      {   2, "Lower travel limit active"  "|de|Hubbegrenzung unten aktiv"  },
      {   3, "Upper travel limit active"  "|de|Hubbegrenzung oben aktiv"   },
      {   4, "End position < active"      "|de|Endlage < aktiv"            },
      {   5, "End position > active"      "|de|Endlage > aktiv"            },
      {   6, "Fail safe behaviour active" "|de|Sicherheitsverhalten aktiv" },
      { 255, "Normal operation"           "|de|Normaler Zustand"           }
  }

  HELP "Shows the current operating status of the internal position "
       "control algorithm."
       "|de|Zeigt den aktuellen Betriebszustand der internen "
       "Stellungsregelung an.";
}

/*----------------------------------------------------------------------------*/
VARIABLE trans1_charact_type
{
  LABEL "Characteristic type" "|de|Kennlinientyp";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ASCII (32);

  HELP "Free text to describe the user defined characteristic."
       "|de|Freier Text zur Beschreibung der benutzerdefinierten Kennlinie.";
}


VARIABLE trans1_signal_pressure_action
{
  LABEL    "Position switch 'AIR TO'" "|de|Stellung Schalter 'AIR TO'";
  CLASS    DEVICE;
  HANDLING READ;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE 1;
    { 0, "CLOSE"     },
    { 1, "OPEN"      },
    { 2, "Undefined"  "|de|Nicht definiert" }
/*    { 0, "Close"     "|de|Zu"    },
    { 1, "Open"      "|de|Offen"   },
    { 2, "Undefined" "|de|Nicht definiert" }*/
  }
  HELP "Position of the switch 'AIR TO' at the positioner."
       "|de|Stellung des Schalters 'AIR TO' am Stellungsregler.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Bauart                       Doku-Nummer: 334   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_actuator_version
{
  LABEL "Model" "|de|Bauart";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    DEFAULT_VALUE 255;
    { 0,   "Single acting" "|de|Einfach wirkend" },
    { 1,   "Double acting" "|de|Doppelt wirkend" },
    { 255, "Undefined"     "|de|Nicht definiert" }
  }

  HELP "Actuator with or without spring loading."
       "|de|Antrieb mit oder ohne Federrckstellung.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Versorgungsdruck             Doku-Nummer: 156   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_supply_pressure
{
  LABEL "Supply pressure" "|de|Versorgungsdruck";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";

      MIN_VALUE 0.0;
      MAX_VALUE 6.0;
  }
  CONSTANT_UNIT "bar";

  HELP "Pressure of the pneumatic supply system."
       "|de|Druck des Zuluftnetzes.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Druckgrenze                  Doku-Nummer: 21    EB-Code: 16   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_pressure_limit
{
  LABEL "Pressure limit" "|de|Druckgrenze";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      { 3, "Off"     "|de|Aus"     },
      { 2, "3.7 bar" "|de|3.7 bar" },
      { 1, "2.4 bar" "|de|2.4 bar" },
      { 0, "1.4 bar" "|de|1.4 bar" }
  }

  HELP "The pressure limit determined during initialization is "
       "displayed and can be modified."
       "|de|Die whrend der Initialisierung ermittelte Druckbegrenzung "
       "wird angezeigt und kann gendert werden.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Set FailSafePosition       Doku-Nummer:       EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_set_fail_safe_pos
{
  LABEL    "Set to fail safe position" "|de|Setzen auf Sicherheitsstellung";
  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    { 0, "Not active"                    "|de|Nicht aktiv"                      },
    { 1, "Activate fail safe position"   "|de|Sicherheitsstellung aktivieren"   },
    { 2, "Deactivate fail safe position" "|de|Sicherheitsstellung deaktivieren" }
  }
  HELP "Set or clear fail safe position mode."
       "|de|Setzen oder Rcksetzen der Sicherheitsstellung.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Hub-/Drehw.-bereich Anfang   Doku-Nummer: 9     EB-Code: 8    */
/*            FINAL_VALUE_RANGE                                             */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_final_value_range_start
{
  LABEL "Travel/angle range start" "|de|Hub-/Drehwinkelbereich Anfang";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";
      DEFAULT_VALUE 0.0;

      MIN_VALUE 0.0;
      MAX_VALUE 200.0;
  }

  HELP "Lower range value for the travel/angle in the nominal or working range."
       "|de|Anfangswert fr den Hub-/Drehwinkel im Nenn- bzw. Arbeitsbereich.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Hub-/Drehwinkelbereich Ende  Doku-Nummer: 10    EB-Code: 9    */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_final_value_range_end
{
  LABEL "Travel/angle range end" "|de|Hub-/Drehwinkelbereich Ende";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";
      DEFAULT_VALUE 100.0;

      MIN_VALUE 0.0;
      MAX_VALUE 200.0;
  }

  HELP "Upper range value for the travel/angle in the nominal or working range."
       "|de|Endwert fr den Hub-/Drehwinkel im Nenn- bzw. Arbeitsbereich.";
}


/* Einheit von Hub-/Drehwinkelbereich Ende */
VARIABLE trans1_final_value_range_units
{
     LABEL "Travel/angle range unit" "|de|Hub-/Drehwinkelbereich Einheit";

     CLASS   DEVICE;
     TYPE 	 ENUMERATED (2)
     {
       DEFAULT_VALUE   1342;

       /* nur % - Auswahl */
       IF(trans1_transm_pin_pos == PIN_POS_OFF)
       {
            { 1342,  [Percent], [Percent_help]  }  /* % */
       }

       /* mm und % - Auswahl */
       IF( (trans1_transm_pin_pos == PIN_POS_17_MM)  ||
           (trans1_transm_pin_pos == PIN_POS_25_MM)  ||
           (trans1_transm_pin_pos == PIN_POS_35_MM)  ||
           (trans1_transm_pin_pos == PIN_POS_50_MM)  ||
           (trans1_transm_pin_pos == PIN_POS_70_MM)  ||
           (trans1_transm_pin_pos == PIN_POS_100_MM) ||
           (trans1_transm_pin_pos == PIN_POS_200_MM)    )
       {
           { 1342,  [Percent], [Percent_help]  }
           { 1013,  "mm",      [mm_help]       }
       }

       /*  und % - Auswahl */
       IF(trans1_transm_pin_pos == PIN_POS_90_GRAD)
       {
           { 1342,  [Percent], [Percent_help]  }
           { 1005,  [degrees], [degrees_help]  }
       }

     }
     HANDLING        READ & WRITE;

     HELP "Unit for range value for the travel/angle in the nominal or working range."
          "|de|Einheit fr den Hub-/Drehwinkel im Nenn- bzw. Arbeitsbereich.";
}

/* Anzahl Dezimalstellen von Hub-/Drehwinkelbereich Ende */
VARIABLE trans1_final_value_range_dec_point /* __decimal_tb */
{
    LABEL           [decimal] ;
    HELP            [decimal_help] ;
    CLASS           DEVICE ;
    TYPE            INTEGER (1) ;
    CONSTANT_UNIT   [blank] ;
    HANDLING        READ & WRITE ;
}

/* ------------------------------------------------------------------------ */
/* Parameter: Toleranzband                 Doku-Nummer: 24    EB-Code: 19   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_tolerance_band
{
  LABEL "Tolerance band" "|de|Toleranzband";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE 5.0;
      DISPLAY_FORMAT "4.1f";
      EDIT_FORMAT    "4.1f";

      MIN_VALUE 0.1;
      MAX_VALUE 10.0;
  }
  CONSTANT_UNIT "%";

  HELP "Used for error monitoring. Determination of the tolerance band in "
       "relation to the working range."
       "|de|Toleranzband bezogen auf den Arbeitsbereich. "
       "Zugehrige Nachlaufzeit ist Rcksetzkriterium. "
       "Wird whrend der Initialisierung eine Laufzeit festgestellt, "
       "deren 6 faches > 30s ist, wird die sechsfache Laufzeit als "
       "Nachlaufzeit bernommen.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Nachlaufzeit                 Doku-Nummer: 133   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_delay_time
{
  LABEL "Delay time" "|de|Nachlaufzeit";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE 10.0;
      DISPLAY_FORMAT "4.1f";
      EDIT_FORMAT    "4.1f";

      MIN_VALUE 0.1;
      MAX_VALUE 9999.0;
  }
  CONSTANT_UNIT "s";

  HELP "Reset criterion for monitoring the active control loop. "
       "When delay time is exceeded and the setpoint deviation is not "
       "within the limits of the tolerance band, a control loop error "
       "is reported."
       "|de|Rcksetzkriterium fr laufende Regelkreis - berwachung. "
       "Wenn die Nachlaufzeit berschritten ist und die Regelabweichung "
       "nicht innerhalb des Toleranzbandes liegt, wird Regelkreisstrung "
       "gemeldet.";
}

/* ------------------------------------------------------------------------ */
VARIABLE trans1_status_solenoid_valve
{
  LABEL "Status solenoid valve" "|de|Status Magnetventil";

  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE ENUMERATED
  {
    { 0, "Not active"      "|de|Nicht aktiv"         },
    { 1, "Active"          "|de|Aktiv"               },
    { 2, "Not implemented" "|de|Nicht implementiert" }
  }

  /* nur sichtbar wenn Magnetventil eingebaut */
/* kmr: parameter 'magnetventil' nicht vorhanden
  VALIDITY
    IF (magnetventil == 1)
    { TRUE; }
    ELSE
    { FALSE; }                             */

  HELP "Status of option solenoid valve." "|de|Status der Option Magnetventil.";
}

/*----------------------------------------------------------------------------*/
VARIABLE    trans1_final_position_value__value
{
    LABEL           "Final position value" "|de|Final position value";
    HELP            [float_input_help] ;
    CLASS           INPUT & DYNAMIC ;
    TYPE     FLOAT
    {
        DISPLAY_FORMAT ".1f" ;
    }
    HANDLING        READ ;
}

/*----------------------------------------------------------------------------*/
VARIABLE    trans1_final_position_value__quality
{
    LABEL           "Status Final position value" "|de|Status Final position value";
    HELP            [status_input_help] ;
    CLASS           INPUT & DYNAMIC ;
    TYPE            ENUMERATED (1)
    {
        STATUS_BAD_UNCERTAIN_GOOD_MASK
    }
    HANDLING        READ;
}

trans1_final_position_value__limit					LIKE VARIABLE	trans1_final_position_value__quality
{
	REDEFINE LABEL		"Limit Final position value" "|de|Limit Final position value";
	REDEFINE TYPE		ENUMERATED (1)
	{
		STATUS_LIMIT
	}
  REDEFINE HELP "Contains status messages about limit violations."
                "|de|Enthlt Statusmeldungen ber Grenzwertverletzungen.";
}

/*----------------------------------------------------------------------------*/
VARIABLE    trans1_final_value__value
{
    LABEL    "Final value" "|de|Final value";
    CLASS    INPUT & DYNAMIC ;
    TYPE     FLOAT
    {
        DEFAULT_VALUE   0.0;
        DISPLAY_FORMAT ".1f" ;
    }
    HANDLING        READ & WRITE;
}

/*----------------------------------------------------------------------------*/
VARIABLE    trans1_final_value__quality
{
    LABEL           "Final value status (quality)" "|de|Final value Status (Qualitt)";
    HELP            [status_input_help] ;
    CLASS           INPUT & DYNAMIC ;
    TYPE            ENUMERATED (1)
    {
        STATUS_BAD_UNCERTAIN_GOOD_MASK
    }
    HANDLING        READ & WRITE;
}

trans1_final_value__limit					LIKE VARIABLE	trans1_final_value__quality
{
	REDEFINE LABEL		"Final value status (limit)" "|de|Final value Status (Limit)";
	REDEFINE TYPE		ENUMERATED (1)
	{
		STATUS_LIMIT
	}
  REDEFINE HELP "Contains status messages about limit violations."
                "|de|Enthlt Statusmeldungen ber Grenzwertverletzungen.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Antriebswirkflche                                            */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_actuator_size
{
  LABEL "Actuator size" "|de|Antriebswirkflche";

  CLASS DEVICE;
  HANDLING READ&WRITE;

  TYPE ENUMERATED (2)
  {
      DEFAULT_VALUE 65535;
      { 60,      "60 cm"   },
      { 80,      "80 cm"   },
      { 120, 	"120 cm" 	},
      { 240, 	"240 cm" 	},
      { 350, 	"350 cm" 	},
      { 700, 	"700 cm" 	},
      { 1400,  "1400 cm" 	},
      { 2800,  "2800 cm" 	},
      { 5600,  "5600 cm" 	},
      { 65535, "Other" "|de|Sonstige" }
  }

  HELP "Effective diaphragm or piston area of the actuator."
       "|de|Wirksame Membran- oder Kolbenflche des Antriebs.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Antriebswirkflche                                            */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_manufac_actuator_size
{
  LABEL "Manufacturer specific actuator size" "|de|Hersteller spezifische Antriebswirkflche";

  CLASS 		DEVICE;
  TYPE  		UNSIGNED_INTEGER (2)
  {
    DEFAULT_VALUE 1; /* auf 1 gesetzt, damit keine Schreibfehler-Meldung */
    MIN_VALUE     1; /* auf 1 gesetzt, damit keine Schreibfehler-Meldung */
    MAX_VALUE 65500;
  }
  HANDLING 	READ&WRITE;
  CONSTANT_UNIT "cm";

  /* wenn Antriebswirkflche = Sonstige : dann sichtbar */
  VALIDITY
    IF (trans1_actuator_size == 65535)
    { TRUE; }
    ELSE
    { FALSE; }

  HELP "Effective diaphragm or piston area of the actuator."
       "|de|Wirksame Membran- oder Kolbenflche des Antriebs.";
}


/* ------------------------------------------------------------------------ */
/* Parameter: Anbau                        Doku-Nummer: 335   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_attachment
{
  LABEL "Attachment" "|de|Anbau";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    DEFAULT_VALUE 255;
    { 0, "SAMSON integrated" 	"|de|SAMSON integriert" 	},
    { 1, "IEC 60534-6 / NAMUR"  "|de|IEC 60534-6 / NAMUR"   },
    { 2, "VDI/VDE 3847 Page1"   "|de|VDI/VDE 3847 Seite 1"  },
    { 3, "VDI/VDE 3845 "      	"|de|VDI/VDE 3845 "      	},
    { 4, "VDI/VDE 3847 Page 2" 	"|de|VDI/VDE 3847 Seite 2 " },
    { 255, "Other"				"|de|Sonstige"          	}
  }

  HELP "Defines positioner attachment to the control valve."
       "|de|Definiert den Anbau des Stellungsreglers an das Stellventil.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Stelldruckbereich Anfang     Doku-Nummer: 154   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_pressure_range_start
{
  LABEL "Signal pressure lower value" "|de|Stelldruckbereich Anfang";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE 0.2;
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";
      MIN_VALUE 0.0;
      MAX_VALUE 6.0;
  }
  CONSTANT_UNIT "bar";

  HELP "Start value of the actuator's spring range."
       "|de|Anfangswert des Federbereiches des Antriebes.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Stelldruckbereich Ende       Doku-Nummer: 155   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_pressure_range_end
{
  LABEL "Signal pressure upper value" "|de|Stelldruckbereich Ende";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";

      MIN_VALUE 0.0;
      MAX_VALUE 6.0;
  }
  CONSTANT_UNIT "bar";

  HELP "End value of the actuator's spring range."
       "|de|Endwert des Federbereiches des Antriebes.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Booster                      Doku-Nummer: 152   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_booster
{
  LABEL "Booster" "|de|Booster";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    { 0, "Not present" "|de|Nicht vorhanden" },
    { 1, "Present"     "|de|Vorhanden"       }
  }

  HELP "Pneumatic volume booster."
       "|de|Pneumatischer Volumenverstrker.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Stangenabdichtung            Doku-Nummer: 159   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_stuffing_box
{
  LABEL "Stuffing box" "|de|Stangenabdichtung";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    DEFAULT_VALUE 255;
    { 0, "Self adjusting" "|de|Selbstnachstellend" },
    { 1, "Retorque"       "|de|Nachziehbar"        },
    { 2, "Bag sealing"    "|de|Balgabdichtung"     },
    { 255, "Other"		  "|de|Sonstige"           }
  }

  HELP "Sealing of the valve stem."
       "|de|Abdichtung der Kegelstange nach aussen.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Dichtkante (Leckageklasse)   Doku-Nummer: 160   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_sealing_edge
{
  LABEL "Sealing edge (leakage class)" "|de|Dichtkante (Leckageklasse)";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    DEFAULT_VALUE 255;
    { 0, "Metal-sealed"  	"|de|Metallisch dichtend" },
    { 1, "Sharpened"     	"|de|Eingeschliffen"      },
    { 2, "Soft-sealed"   	"|de|Weichdichtend"       },
    { 3, "Nickel-sealed" 	"|de|Nickeldichtung"      },
    { 255, "Others" 			"|de|Sonstige"      			}
  }

  HELP "Type of sealing between seat and plug."
       "|de|Art der Abdichtung zwischen Sitz und Kegel.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Druckentlastung              Doku-Nummer: 161   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_pressure_balancing
{
  LABEL "Press. balancing" "|de|Druckentlastung";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    DEFAULT_VALUE 255;
    { 0, "None"            "|de|Ohne"          },
    { 1, "With (PTFE)"     "|de|Mit (PTFE)"    },
    { 2, "With (graphite)" "|de|Mit (Graphit)" },
    { 255, "Others" 	   "|de|Sonstige"      }
  }

  HELP "Plug with mostly compensated stroking forces."
       "|de|Kegel mit weitgehender Kompensation der Stellkrfte.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Kennlinie Kegel              Doku-Nummer: 162   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_flow_characteristic
{
  LABEL "Flow characteristic" "|de|Kennlinie Kegel";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    DEFAULT_VALUE 255;
    { 0, "Linear 30:1"           	"|de|Linear 30:1"          	},
    { 1, "Equal percentage 30:1" 	"|de|Gleichprozentig 30:1" 	},
    { 2, "Linear 50:1"           	"|de|Linear 50:1"          	},
    { 3, "Equal percentage 50:1" 	"|de|Gleichprozentig 50:1" 	},
    { 4, "Vetec 200:1" 				"|de|Vetec 200:1" 			},
    { 255, "Other"                  "|de|Sonstige"             	}
  }

  HELP "Valve characteristic flow versus valve travel."
       "|de|Ventilkennlinie Durchfluss zu Ventilhub.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Fliessrichtung               Doku-Nummer: 158   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_flow_direction
{
  LABEL "Flow direction" "|de|Flierichtung";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    DEFAULT_VALUE 255;
    { 0, "Valve opening (FTO)" "|de|Ventil ffnend (FTO)"     },
    { 1, "Valve closing (FTC)" "|de|Ventil schliessend (FTC)" },
    { 2, "Alternating" "|de|Wechselnd" },
    { 255, "Other" "|de|Sonstige" }
  }

  HELP "Flow direction of the medium against the valve trim."
       "|de|Anstrmrichtung Medium zu Drosselelement des Ventils.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Nennweiten-Norm              Doku-Nummer: 163   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_nom_diameter
{
  LABEL "Nominal diameter" "|de|Nennweiten-Norm";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    { 0, "DIN [mm]"  			"|de|DIN [mm]"},
    { 1, "ANSI [inch]" 		"|de|ANSI [inch]"},
    { 2, "IG [mm]" 				"|de|IG [mm]"},
    { 3, "JIS [mm]" 			"|de|JIS [mm]"},
    { 4, "BS [inch]" 			"|de|BS [inch]"},
    { 254, "Other [mm]" 	"|de|Sonstige [mm]"},
    { 255, "Other [inch]" "|de|Sonstige [inch]"}
  }

  HELP "Valve dimensions according to DIN or ANSI standard."
       "|de|Ventilabmessumgen nach DIN- oder ANSI-Norm.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Nennweite DN                 Doku-Nummer: 164   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_nom_diameter_dn
{
  LABEL "Nominal diameter DN" "|de|Nennweite DN";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "4.2f";
      EDIT_FORMAT    "4.2f";

      DEFAULT_VALUE 50.00;
      MIN_VALUE 0.00;
      MAX_VALUE 2100.00;
  }

  HELP "Diameter in mm (DIN) or inches (ANSI)."
       "|de|Nennweite in mm (DIN) oder Zoll (ANSI).";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Kvs Einheit                  Doku-Nummer: 165   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_kvs_unit
{
  LABEL "Kvs unit" "|de|Kvs Einheit";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    { 0, "Kv" },
    { 1, "Cv" }
  }

  HELP "Flow coefficient based metric (kvs) or us-american (cv)."
       "|de|Durchfluss - Koeffizient aus Einheiten metrisch (kvs) "
       "oder US-amerikanisch (cv).";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Kvs Wert                     Doku-Nummer: 166   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_kvs_value
{
  LABEL "Kvs value" "|de|Kvs Wert";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "10.4f";
      EDIT_FORMAT    "10.4f";

      MIN_VALUE 0.0001;
      MAX_VALUE 20000.0;
  }
  /* Einheit von kvs_einheit abhaengig */
  CONSTANT_UNIT
    IF (trans1_kvs_unit == 0)
    { "Kv"; }
    ELSE
    { "Cv"; }

  HELP "Flow coefficient of the valve."
       "|de|Durchfluss - Koeffizient des Ventils.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Sitzdurchmesser Ventil       Doku-Nummer: 167   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_seat_diam_valve
{
  LABEL "Seat diameter valve" "|de|Sitzdurchmesser Ventil";

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";
      DEFAULT_VALUE   6.0;
      MIN_VALUE       2.0;
      MAX_VALUE    2100.0;
  }
  CONSTANT_UNIT "mm";

  HELP "Diameter of the valve seat."
       "|de|Durchmesser der Sitzbohrung des Ventils.";
}

/* ------------------------------------------------------------------------ */
/* Parameter: Benutzerdefinierte Kennlinie                                  */
/* ------------------------------------------------------------------------ */
VARIABLE trans1_X0
{
  LABEL "x[0]";
  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE   0.0;
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP "Coordinates for user - defined control valve characteristic. x[n] = "
       "reference variable in % of the respective range. y[n] = travel / opening "
       "angle in % of the respective range."
       "|de|Sttzwerte fr benutzerdefinierte Zuordnung zwischen "
       "Fhrungsgre und Hub / Drehwinkel. x[n] = Fhrungsgre in % "
       "des Fhrungsgrenbereichs. y[n] = Hub- / Drehwinkel in % des "
       "Hub / Drehwinkelbereichs.";
}

trans1_X1 	LIKE VARIABLE		trans1_X0
{ REDEFINE LABEL "X[1]" ;
  REDEFINE TYPE     FLOAT
  {
      DEFAULT_VALUE   10.0;
  }
}

trans1_X2 	LIKE VARIABLE		trans1_X0
{ REDEFINE LABEL "X[2]" ;
  REDEFINE TYPE     FLOAT
  {
      DEFAULT_VALUE   20.0;
  }
}

trans1_X3 	LIKE VARIABLE		trans1_X0
{ REDEFINE LABEL "X[3]" ;
  REDEFINE TYPE     FLOAT
  {
      DEFAULT_VALUE   30.0;
  }
}

trans1_X4 	LIKE VARIABLE		trans1_X0
{ REDEFINE LABEL "X[4]" ;
  REDEFINE TYPE     FLOAT
  {
      DEFAULT_VALUE   40.0;
  }
}

trans1_X5 	LIKE VARIABLE		trans1_X0
{ REDEFINE LABEL "X[5]" ;
  REDEFINE TYPE     FLOAT
  {
      DEFAULT_VALUE   50.0;
  }
}

trans1_X6 	LIKE VARIABLE		trans1_X0
{ REDEFINE LABEL "X[6]" ;
  REDEFINE TYPE     FLOAT
  {
      DEFAULT_VALUE   60.0;
  }
}

trans1_X7 	LIKE VARIABLE		trans1_X0
{ REDEFINE LABEL "X[7]" ;
  REDEFINE TYPE     FLOAT
  {
      DEFAULT_VALUE   70.0;
  }
}

trans1_X8 	LIKE VARIABLE		trans1_X0
{ REDEFINE LABEL "X[8]" ;
  REDEFINE TYPE     FLOAT
  {
      DEFAULT_VALUE   80.0;
  }
}

trans1_X9 	LIKE VARIABLE		trans1_X0
{ REDEFINE LABEL "X[9]" ;
  REDEFINE TYPE     FLOAT
  {
      DEFAULT_VALUE   90.0;
  }
}

trans1_X10 	LIKE VARIABLE		trans1_X0
{ REDEFINE LABEL "X[10]" ;
  REDEFINE TYPE     FLOAT
  {
      DEFAULT_VALUE   100.0;
  }
}

trans1_Y0 	LIKE VARIABLE		trans1_X0
{ REDEFINE LABEL "Y[0]" ;}

trans1_Y1 	LIKE VARIABLE		trans1_X1
{ REDEFINE LABEL "Y[1]" ;}

trans1_Y2 	LIKE VARIABLE		trans1_X2
{ REDEFINE LABEL "Y[2]" ;}

trans1_Y3 	LIKE VARIABLE		trans1_X3
{ REDEFINE LABEL "Y[3]" ;}

trans1_Y4 	LIKE VARIABLE		trans1_X4
{ REDEFINE LABEL "Y[4]" ;}

trans1_Y5 	LIKE VARIABLE		trans1_X5
{ REDEFINE LABEL "Y[5]" ;}

trans1_Y6 	LIKE VARIABLE		trans1_X6
{ REDEFINE LABEL "Y[6]" ;}

trans1_Y7 	LIKE VARIABLE		trans1_X7
{ REDEFINE LABEL "Y[7]" ;}

trans1_Y8 	LIKE VARIABLE		trans1_X8
{ REDEFINE LABEL "Y[8]" ;}

trans1_Y9 	LIKE VARIABLE		trans1_X9
{ REDEFINE LABEL "Y[9]" ;}

trans1_Y10 	LIKE VARIABLE		trans1_X10
{ REDEFINE LABEL "Y[10]" ;}


/***********************************************************************/
/*    Function Block                                                   */
/***********************************************************************/
BLOCK function_block_1
{
    TYPE    FUNCTION;
    NUMBER  1;
}

func1_blk_reserve                           LIKE VARIABLE   phys_blk_reserve
{
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_blk_object
{
    LABEL       [blk_block_object];
    HELP        [blk_block_object_help];
    CLASS       DEVICE;
    TYPE        ENUMERATED(1)
    {
        {   2,  [blk_block_object_FUNCTION]     }
    }
    HANDLING    READ;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_blk_parent_class
{
    LABEL       [blk_parent_class];
    HELP        [func_blk_parent_class_help];
    CLASS       DEVICE;
    TYPE        ENUMERATED(1)
    {
        {   2,  [func_blk_parent_class_OUTPUT]  }
    }
    HANDLING    READ;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_blk_class
{
    LABEL       [blk_class];
    HELP        [func_blk_class_help];
    CLASS       DEVICE;
    TYPE        ENUMERATED(1)
    {
        {   1,  [func_blk_class_AO]     }
    }
    HANDLING    READ;
}
/*----------------------------------------------------------------------------*/
func1_blk_dd_reference              LIKE VARIABLE   phys_blk_dd_reference
{
}
/*----------------------------------------------------------------------------*/
func1_blk_dd_rev                    LIKE VARIABLE   phys_blk_dd_rev
{
}
/*----------------------------------------------------------------------------*/
func1_blk_profile                   LIKE VARIABLE   phys_blk_profile
{
}
/*----------------------------------------------------------------------------*/
func1_blk_profile_rev               LIKE VARIABLE   phys_blk_profile_rev
{
}
/*----------------------------------------------------------------------------*/
func1_blk_execution_time            LIKE VARIABLE   phys_blk_execution_time
{
}
/*----------------------------------------------------------------------------*/
func1_blk_num_parameters            LIKE VARIABLE   blk_num_parameters
{
}
/*----------------------------------------------------------------------------*/
func1_blk_index_view_1              LIKE VARIABLE   phys_blk_index_view_1
{
}
/*----------------------------------------------------------------------------*/
func1_blk_num_view_lists            LIKE VARIABLE   phys_blk_num_view_lists
{
}
/*----------------------------------------------------------------------------*/
func1_st_rev                        LIKE VARIABLE   phys_st_rev
{
   REDEFINE LABEL    [st_rev] + " (Function Block)";
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_tag_desc
{
/*    LABEL       [tag_desc];*/
    LABEL       "TAG (Function block)" "|de|TAG (Function Block)";
    CLASS       DEVICE;
    TYPE        ASCII (32)
    {
      DEFAULT_VALUE   "-/-";
    }
    HANDLING    READ & WRITE;

    HELP        [tag_desc_help];
}
/*----------------------------------------------------------------------------*/
func1_strategy                      LIKE VARIABLE   phys_strategy
{
   REDEFINE LABEL    [strategy] + " (Function Block)";
}
/*----------------------------------------------------------------------------*/
func1_alert_key                     LIKE VARIABLE   phys_alert_key
{
   REDEFINE LABEL    [alert_key] + " (Function Block)";
}
/*----------------------------------------------------------------------------*/
func1_target_mode                   LIKE VARIABLE   phys_target_mode
{
    REDEFINE TYPE       ENUMERATED (1)
    {
        DEFAULT_VALUE   BLOCK_MODE_AUTO;
        {   0x02,   [mode_RCAS]                 },
        {   0x08,   [mode_AUTO]                 },
        {   0x10,   [mode_MAN]                  },
        {   0x80,   [mode_OUT_OF_SERVICE] 			}

    }
}
/*----------------------------------------------------------------------------*/
func1_actual_mode                   LIKE VARIABLE   phys_actual_mode
{
    REDEFINE TYPE       ENUMERATED (1)
    {
        {   0x02,   [mode_RCAS]             },
        {   0x08,   [mode_AUTO]             },
        {   0x10,   [mode_MAN]              },
        {   0x20,   [mode_LO]               },
        {   0x80,   [mode_OUT_OF_SERVICE]   }
    }
}
/*----------------------------------------------------------------------------*/
func1_permitted_mode                LIKE VARIABLE   phys_permitted_mode
{
    REDEFINE TYPE       BIT_ENUMERATED (1)
    {
        {   0x02,   [mode_RCAS]             },
        {   0x08,   [mode_AUTO]             },
        {   0x10,   [mode_MAN]              },
        {   0x80,   [mode_OUT_OF_SERVICE]   }
    }
}
/*----------------------------------------------------------------------------*/
func1_normal_mode                   LIKE VARIABLE   phys_normal_mode
{
    REDEFINE TYPE       ENUMERATED (1)
    {
        {   0x02,   [mode_RCAS]             },
        {   0x08,   [mode_AUTO]             },
        {   0x10,   [mode_MAN]              },
        {   0x20,   [mode_LO]               },
        {   0x80,   [mode_OUT_OF_SERVICE]   }
    }
}
/*----------------------------------------------------------------------------*/
func1_current_state_alarm_sum       LIKE VARIABLE   phys_current_state_alarm_sum
{
    REDEFINE TYPE       BIT_ENUMERATED (2)
    {
        {   0x0000, [limit_state_NO_ALARM]  },
        {   0x0200, [limit_state_HI_HI]     },
        {   0x0400, [limit_state_HI]        },
        {   0x0800, [limit_state_LO_LO]     },
        {   0x1000, [limit_state_LO]        },
        {   0x8000, [limit_state_ST_REV]    }
    }
}
/*----------------------------------------------------------------------------*/
func1_unacknowledged_state_alarm_sum        LIKE VARIABLE   phys_unacknowledged_state_alarm_sum
{
    REDEFINE TYPE       BIT_ENUMERATED (2)
    {
        {   0x0000, [limit_state_NO_ALARM]  },
        {   0x0200, [limit_state_HI_HI]     },
        {   0x0400, [limit_state_HI]        },
        {   0x0800, [limit_state_LO_LO]     },
        {   0x1000, [limit_state_LO]        },
        {   0x8000, [limit_state_ST_REV]    }
    }
}
/*----------------------------------------------------------------------------*/
func1_unreported_state_alarm_sum            LIKE VARIABLE   phys_unreported_state_alarm_sum
{
    REDEFINE TYPE       BIT_ENUMERATED (2)
    {
        {   0x0000, [limit_state_NO_ALARM]  },
        {   0x0200, [limit_state_HI_HI]     },
        {   0x0400, [limit_state_HI]        },
        {   0x0800, [limit_state_LO_LO]     },
        {   0x1000, [limit_state_LO]        },
        {   0x8000, [limit_state_ST_REV]    }
    }
}
/*----------------------------------------------------------------------------*/
func1_disabled_state_alarm_sum              LIKE VARIABLE   phys_disabled_state_alarm_sum
{
    REDEFINE TYPE       BIT_ENUMERATED (2)
    {
        {   0x0000, [limit_state_NO_ALARM]  },
        {   0x0200, [limit_state_HI_HI]     },
        {   0x0400, [limit_state_HI]        },
        {   0x0800, [limit_state_LO_LO]     },
        {   0x1000, [limit_state_LO]        },
        {   0x8000, [limit_state_ST_REV]    }
    }
}

/*---------------------------------------------------------------------*/
/*    Function Block: Analog Output                                    */
/*---------------------------------------------------------------------*/
VARIABLE func1_batch_id
{
    LABEL       [func_batch_id];
    HELP        [func_batch_id_help];
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER (4)
    {
        DEFAULT_VALUE   0;
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_batch_unit
{
    LABEL       [func_batch_unit];
    HELP        [func_batch_unit_help];
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE   0;
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_batch_operation
{
    LABEL       [func_batch_operation];
    HELP        [func_batch_operation_help];
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE   0;
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_batch_phase
{
    LABEL       [func_batch_phase];
    HELP        [func_batch_phase_help];
    CLASS       DEVICE;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE   0;
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_setpoint_value
{
/*    LABEL       [func_ao_setpoint_value];*/
    LABEL "Reference variable W" "|de|Fhrungsgre W";
    HELP        [func_ao_setpoint_value_help];
    CLASS       DEVICE & DYNAMIC;
    TYPE        FLOAT
    {
        DEFAULT_VALUE   0.0;
        DISPLAY_FORMAT ".1f" ;
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_setpoint_status
{
    LABEL	"Reference variable status (quality)" "|de|Fhrungsgre Status (Qualitt)";
    HELP        [func_ao_setpoint_status_help];
    CLASS       DEVICE & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        STATUS_BAD_UNCERTAIN_GOOD_MASK
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
func1_setpoint_status_limit    LIKE VARIABLE   func1_rcas_out_status_quality
{
    REDEFINE LABEL "Reference variable status (limit)" "|de|Fhrungsgre Status (Limit)";
    REDEFINE TYPE       ENUMERATED (1)
    {
        STATUS_LIMIT
    }
    REDEFINE HANDLING    READ & WRITE;
    REDEFINE HELP "Contains status messages about limit violations."
                  "|de|Enthlt Statusmeldungen ber Grenzwertverletzungen.";
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_pv_upper_range_value
{
    LABEL "Reference var. range - input scaling end"
          "|de|Fhrungsgrenbereich - Eingangsskalierung Ende";
    HELP        [func_pv_scale_upper_value_help];
    CLASS       DEVICE;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT    ".1f";
        DEFAULT_VALUE   100.0;
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_pv_lower_range_value
{
    LABEL "Reference var. range - input scaling start"
          "|de|Fhrungsgrenbereich - Eingangsskalierung Anfang";
    HELP        [func_pv_scale_lower_value_help];
    CLASS       DEVICE;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT   ".1f";
        DEFAULT_VALUE    0.0;
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_pv_unit
{
    LABEL "Reference var. range - input scaling unit"
          "|de|Fhrungsgrenbereich - Eingangsskalierung Einheit";
    HELP        [func_pv_scale_unit_help];
    CLASS       DEVICE;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE   1342;
        UNIT_LIST
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_pv_decimal_point
{
    LABEL       [decimal_point];
    HELP        [decimal_point_help];
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,   "0"        },
        {   1,   "1"        },
        {   2,   "2"        },
        {   3,   "3"        },
        {   4,   "4"        },
        {   5,   "5"        },
        {   6,   "6"        }
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_readback_value
{
/*    LABEL       [func_ao_readback_value];*/
    LABEL	"Controlled variable X" "|de|Regelgre X";
    HELP        [func_ao_readback_value_help];
    CLASS       DEVICE & DYNAMIC;
    TYPE        FLOAT
    {
        DEFAULT_VALUE   0.0;
        DISPLAY_FORMAT ".1f" ;
    }
    HANDLING    READ;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_readback_status
{
    LABEL	"Controlled variable status (quality)" "|de|Regelgre Status (Qualitt)";
    HELP        [func_ao_readback_status_help];
    CLASS       DEVICE & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        STATUS_BAD_UNCERTAIN_GOOD_MASK
    }
    HANDLING    READ;
}
/*----------------------------------------------------------------------------*/
func1_readback_status_limit    LIKE VARIABLE   func1_rcas_out_status_quality
{
    REDEFINE LABEL "Controlled variable status (limit)" "|de|Regelgre Status (Limit)";
    REDEFINE TYPE       ENUMERATED (1)
    {
        STATUS_LIMIT
    }
    REDEFINE HELP "Contains status messages about limit violations."
                  "|de|Enthlt Statusmeldungen ber Grenzwertverletzungen.";
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_rcas_in_value
{
    LABEL       [func_rcas_in_value];
    HELP        [func_rcas_in_value_help];
    CLASS       DEVICE & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT   ".1f";
        DEFAULT_VALUE    0.0;
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_rcas_in_status
{
    LABEL       [func_rcas_in_status];
    HELP        [func_rcas_in_status_help];
    CLASS       DEVICE & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
/*        DEFAULT_VALUE   0x1B; nicht bei _MASK !*/
        DEFAULT_VALUE   6;
        STATUS_BAD_UNCERTAIN_GOOD_MASK
        STATUS_GOOD_CASCADE_MASK
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_in_channel
{
    LABEL       "Channel In" "|de|Kanal Eingang";
    HELP        [func_channel_help];
    CLASS       DEVICE;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE   314;
        {      0,  "Not active" "|de|Nicht aktiv" },
        {    314,  "Active"     "|de|Aktiv"       }
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_out_channel
{
    LABEL       "Channel Out" "|de|Kanal Ausgang";
    HELP        [func_channel_help];
    CLASS       DEVICE;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE   313;
        {      0,  "Not active" "|de|Nicht aktiv" },
        {    313,  "Active"     "|de|Aktiv"       }
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_fsafe_time
{
    LABEL       [func_ao_fsafe_time];
    HELP        [func_ao_fsafe_time_help];
    CLASS       DEVICE;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT   ".0f";
        DEFAULT_VALUE 0.0;
        MIN_VALUE 0.0;
        MAX_VALUE 3600.0;
    }
    CONSTANT_UNIT   [sec];
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_fsafe_type
{
    LABEL       [func_ao_fsafe_type];
    HELP        [func_ao_fsafe_type_help];
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,  [func_ao_fsafe_type_FAIL_SAFE_VALUE]        },
        {   1,  [func_ao_fsafe_type_STORING_LAST_SETPOINT]  },
        {   2,  [func_ao_fsafe_type_FAIL_SAFE_POSITION]     }
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_fsafe_value
{
    LABEL       [func_ao_fsafe_value];
    HELP        [func_ao_fsafe_value_help];
    CLASS       DEVICE;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT    ".1f";
        DEFAULT_VALUE 0.0;
        MIN_VALUE 0.0;
        MAX_VALUE 100.0;
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_rcas_out_value
{
    LABEL       [func_rcas_out_value];
    HELP        [func_rcas_out_value_help];
    CLASS       DEVICE & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT   ".1f";
    }
    HANDLING    READ;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_rcas_out_status_quality
{
    LABEL	"RCAS OUT status (quality)" "|de|RCAS OUT Status (Qualitt)";
    HELP        [func_rcas_out_status_help];
    CLASS       DEVICE & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        STATUS_BAD_UNCERTAIN_GOOD_MASK
        STATUS_GOOD_CASCADE_MASK
    }
    HANDLING    READ;
}
/*----------------------------------------------------------------------------*/
func1_rcas_out_status_limit         LIKE VARIABLE   func1_rcas_out_status_quality
{
    REDEFINE LABEL	"RCAS OUT status (limit)" "|de|RCAS OUT Status (Limit)";
    REDEFINE TYPE       ENUMERATED (1)
    {
        STATUS_LIMIT
    }
    REDEFINE HELP "Contains status messages about limit violations."
                  "|de|Enthlt Statusmeldungen ber Grenzwertverletzungen.";
}
/*----------------------------------------------------------------------------*/
/* POS_D */
VARIABLE func1_position_discrete_value
{
    LABEL       [func_ao_position_discrete_value];
    HELP        [func_ao_position_discrete_value_help];
    CLASS       DEVICE & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        {   0,  [func_ao_position_discrete_status_NOT_INIT]         },
        {   1,  [func_ao_position_discrete_status_CLOSED]           },
        {   2,  [func_ao_position_discrete_status_OPENED]           },
        {   3,  [func_ao_position_discrete_status_INTERMEDIATE]     }
    }
    HANDLING    READ;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_position_discrete_status
{
    LABEL       [func_ao_position_discrete_status];
    HELP        [func_ao_position_discrete_status_help];
    CLASS       DEVICE & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        STATUS_BAD_UNCERTAIN_GOOD_MASK
    }
    HANDLING    READ;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_setpoint_deviation
{
/*    LABEL       [func_ao_setpoint_deviation];*/
    LABEL "Setpoint deviation e" "|de|Regeldifferenz e";
    CLASS       DEVICE & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT   ".1f";
    }
    CONSTANT_UNIT   [Percent];
    HANDLING    READ;

/*    HELP        [func_ao_setpoint_deviation_help];*/
    HELP "Deviation from the reference position."
         "|de|Abweichung von der Sollposition.";
}

/*----------------------------------------------------------------------------*/
#define CB_FAIL_SAFE            0x010000      /* Bit  0 */
#define CB_REQ_LOC_OP           0x020000      /* Bit  1 */
#define CB_LOCAL_OP             0x040000      /* Bit  2 */
#define CB_OVERRIDE             0x080000      /* Bit  3 */
#define CB_DISC_DIR             0x100000      /* Bit  4 */
#define CB_TORQUE_D_OP          0x200000      /* Bit  5 */
#define CB_TORQUE_D_CL          0x400000      /* Bit  6 */
#define CB_TRAV_TIME            0x800000      /* Bit  7 */

#define CB_ACT_OPEN             0x000100      /* Bit  8 */
#define CB_ACT_CLOSE            0x000200      /* Bit  9 */
#define CB_UPDATE_EVT           0x000400      /* Bit 10 */
#define CB_SIMULATE             0x000800      /* Bit 11 */
#define CB_DISTURBANCE          0x001000      /* Bit 12 */
#define CB_CONTR_ERR            0x002000      /* Bit 13 */
#define CB_CONTR_INACT          0x004000      /* Bit 14 */
#define CB_SELFTEST             0x008000      /* Bit 15 */

#define CB_TOT_VALVE_TRAV       0x000001      /* Bit 16 */
#define CB_BINARY_INPUT			0x000002      /* Bit 17 */
#define CB_ZERO_POINT_ERROR     0x000080      /* Bit 23 */

VARIABLE func1_check_back
{
    LABEL       [func_check_back];
    HELP        [func_check_back_help];
    CLASS       DEVICE & DYNAMIC & DIAGNOSTIC;
    TYPE        BIT_ENUMERATED (3)
    {
        {   0,                  [dia_OK],                      [dia_OK_help]            },
        {   CB_FAIL_SAFE,       "Device in fail-safe position"
                                "|de|Gert in Sicherheitsstellung",
                                                               [cb_FAIL_SAFE_help]      },
        {   CB_REQ_LOC_OP,      [cb_REQ_LOC_OP],               [cb_REQ_LOC_OP_help]     },
        {   CB_LOCAL_OP,        [cb_LOCAL_OP],                 [cb_LOCAL_OP_help]       },
        {   CB_OVERRIDE,        "Solenoid valve inactive"
                                "|de|Magnetventil inaktiv",  [cb_OVERRIDE_help]       },
/*      {   CB_DISC_DIR,        [cb_DISC_DIR],                 [cb_DISC_DIR_help]       },
        {   CB_TORQUE_D_OP,     [cb_TORQUE_D_OP],              [cb_TORQUE_D_OP_help]    },
        {   CB_TORQUE_D_CL,     [cb_TORQUE_D_CL],              [cb_TORQUE_D_CL_help]    },*/
        {   CB_TRAV_TIME,       [cb_TRAV_TIME],                [cb_TRAV_TIME_help]      },
/*      {   CB_ACT_OPEN,        [cb_ACT_OPEN],                 [cb_ACT_OPEN_help]       },
        {   CB_ACT_CLOSE,       [cb_ACT_CLOSE],                [cb_ACT_CLOSE_help]      },*/
	    {   CB_UPDATE_EVT,	    "Static data changed"
	                            "|de|Statische Daten wurden gendert",
	                                                           [cb_UPDATE_EVT_help]     },
        {   CB_SIMULATE,        [cb_SIMULATE],                 [cb_SIMULATE_help]       },
/*      {   CB_DISTURBANCE,     [cb_DISTURBANCE],              [cb_DISTURBANCE_help]    },*/
        {   CB_CONTR_ERR,       [cb_CONTR_ERR],                [cb_CONTR_ERR_help]      },
        {   CB_CONTR_INACT,     [cb_CONTR_INACT],              [cb_CONTR_INACT_help]    },
        {   CB_SELFTEST,        [cb_SELFTEST],                 [cb_SELFTEST_help]       },
        {   CB_TOT_VALVE_TRAV,  [cb_TOT_VALVE_TRAV],           [cb_TOT_VALVE_TRAV_help] },
        {   CB_BINARY_INPUT,    "Binary input active" "|de|Binreingang aktiv",
                                "Binary input active" "|de|Binreingang aktiv" },
        {   CB_ZERO_POINT_ERROR,"Zero point error"    "|de|Nullpunktfehler",
                                "Zero point error"    "|de|Nullpunktfehler" }
    }
    HANDLING    READ;
#ifdef _V510_
    STYLE "MULTILINE 12 5" ; /* 5 Zeilen hoch */
#endif
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_check_back_mask
{
    LABEL       [func_check_back_mask];
    HELP        [func_check_back_mask_help];
    CLASS       DEVICE;
    TYPE        BIT_ENUMERATED (3)
    {
        {   CB_FAIL_SAFE,       "Device in fail-safe position"
                                "|de|Gert in Sicherheitsstellung",
                                                        [cb_FAIL_SAFE_help]         },
        {   CB_REQ_LOC_OP,      [cb_REQ_LOC_OP],        [cb_REQ_LOC_OP_help]        },
        {   CB_LOCAL_OP,        [cb_LOCAL_OP],          [cb_LOCAL_OP_help]          },
/*        {   CB_OVERRIDE,        [cb_OVERRIDE],          [cb_OVERRIDE_help]          },*/
        {   CB_OVERRIDE,        "Solenoid valve inactive"
                                "|de|Magnetventil inaktiv",
                                                        [cb_OVERRIDE_help]          },
        {   CB_DISC_DIR,        [cb_DISC_DIR],          [cb_DISC_DIR_help]          },
        {   CB_TORQUE_D_OP,     [cb_TORQUE_D_OP],       [cb_TORQUE_D_OP_help]       },
        {   CB_TORQUE_D_CL,     [cb_TORQUE_D_CL],       [cb_TORQUE_D_CL_help]       },
        {   CB_TRAV_TIME,       [cb_TRAV_TIME],         [cb_TRAV_TIME_help]         },
        {   CB_ACT_OPEN,        [cb_ACT_OPEN],          [cb_ACT_OPEN_help]          },
        {   CB_ACT_CLOSE,       [cb_ACT_CLOSE],         [cb_ACT_CLOSE_help]         },
		{	CB_UPDATE_EVT,		"Static data changed"
	                            "|de|Statische Daten wurden gendert", [cb_UPDATE_EVT_help] },
        {   CB_SIMULATE,        [cb_SIMULATE],          [cb_SIMULATE_help]          },
        {   CB_DISTURBANCE,     [cb_DISTURBANCE],       [cb_DISTURBANCE_help]       },
        {   CB_CONTR_ERR,       [cb_CONTR_ERR],         [cb_CONTR_ERR_help]         },
        {   CB_CONTR_INACT,     [cb_CONTR_INACT],       [cb_CONTR_INACT_help]       },
        {   CB_SELFTEST,        [cb_SELFTEST],          [cb_SELFTEST_help]          },
        {   CB_TOT_VALVE_TRAV,  [cb_TOT_VALVE_TRAV],    [cb_TOT_VALVE_TRAV_help]    },
        {   CB_BINARY_INPUT,    "Binary input active" 	"|de|Binreingang aktiv",
                                "Binary input active"   "|de|Binreingang aktiv"    },
        {   CB_ZERO_POINT_ERROR,"Zero point error"      "|de|Nullpunktfehler",
                                "Zero point error"      "|de|Nullpunktfehler"       }
    }
    HANDLING    READ;
}
/*----------------------------------------------------------------------------*/

VARIABLE func1_check_back_opt
{
    LABEL       "Selection device status messages"
                "|de|Auswahl Gertestatusmeldungen";
    CLASS       DEVICE;
    TYPE        BIT_ENUMERATED (3)
    {
        {   CB_FAIL_SAFE,       "Device in fail-safe position"
                                "|de|Gert in Sicherheitsstellung",
                                                        [cb_FAIL_SAFE_help]         },
        {   CB_REQ_LOC_OP,      [cb_REQ_LOC_OP],        [cb_REQ_LOC_OP_help]        },
        {   CB_LOCAL_OP,        [cb_LOCAL_OP],          [cb_LOCAL_OP_help]          },
        {   CB_OVERRIDE,        "Solenoid valve inactive"
                                "|de|Magnetventil inaktiv", [cb_OVERRIDE_help]    },
/* not supported        {   CB_DISC_DIR,        [cb_DISC_DIR],          [cb_DISC_DIR_help]          },*/
/* not supported        {   CB_TORQUE_D_OP,     [cb_TORQUE_D_OP],       [cb_TORQUE_D_OP_help]       },*/
/* not supported        {   CB_TORQUE_D_CL,     [cb_TORQUE_D_CL],       [cb_TORQUE_D_CL_help]       },*/
        {   CB_TRAV_TIME,       [cb_TRAV_TIME],         [cb_TRAV_TIME_help]         },
/* not supported        {   CB_ACT_OPEN,        [cb_ACT_OPEN],          [cb_ACT_OPEN_help]          },*/
/* not supported        {   CB_ACT_CLOSE,       [cb_ACT_CLOSE],         [cb_ACT_CLOSE_help]         },*/
		{	CB_UPDATE_EVT,		"Static data changed"
	                            "|de|Statische Daten wurden gendert", [cb_UPDATE_EVT_help] },
        {   CB_SIMULATE,        [cb_SIMULATE],          [cb_SIMULATE_help]          },
/*        {   CB_DISTURBANCE,     [cb_DISTURBANCE],       [cb_DISTURBANCE_help]       },*/
        {   CB_CONTR_ERR,       [cb_CONTR_ERR],         [cb_CONTR_ERR_help]         },
        {   CB_CONTR_INACT,     [cb_CONTR_INACT],       [cb_CONTR_INACT_help]       },
        {   CB_SELFTEST,        [cb_SELFTEST],          [cb_SELFTEST_help]          },
        {   CB_TOT_VALVE_TRAV,  [cb_TOT_VALVE_TRAV],    [cb_TOT_VALVE_TRAV_help]    },
        {   CB_BINARY_INPUT,    "Binary input active" 	"|de|Binreingang aktiv",
                                "Binary input active"   "|de|Binreingang aktiv"    },
        {   CB_ZERO_POINT_ERROR,"Zero point error"      "|de|Nullpunktfehler",
                                "Zero point error"      "|de|Nullpunktfehler"       }
    }
    HANDLING    READ & WRITE;
#ifdef _V510_
    STYLE "MULTILINE 13 13" ; /* 13 Zeilen hoch (2. Wert) */
#endif
    HELP    "Activation or deactivation of device status messages."
            "|de|Aktivieren oder Deaktivieren der Gertestatusmeldungen.";
}



/*----------------------------------------------------------------------------*/
VARIABLE func1_simulate_enabled
 {
    LABEL       [func_simulation_enabled];
    HELP        [func_simulation_enabled_help];
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,  [disabled]      },
        {   1,  [enabled]       }
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
VARIABLE func1_simulate_value
{
    LABEL      "Simulation value" "|de|Simulationswert";
    HELP        [func_ao_simulate_value_help];
    CLASS       DEVICE;
    TYPE        FLOAT
    {
        DEFAULT_VALUE     0.0;
        DISPLAY_FORMAT   ".1f";
    }
    HANDLING
		IF (func1_simulate_enabled == 1)
		{
			READ & WRITE;
		}
		ELSE {
			READ;
		}
	/* Einheit siehe unit relation */
}

/*----------------------------------------------------------------------------*/
VARIABLE func1_simulate_status_quality
{
    LABEL      "Simulation value status (quality)"
               "|de|Simulationswert Status (Qualitt)";
    HELP        [func_simulate_status_help];
    CLASS       DEVICE;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   19;
        STATUS_BAD_UNCERTAIN_GOOD_MASK
    }
    HANDLING
		IF (func1_simulate_enabled == 1)
		{
			READ & WRITE;
		}
		ELSE {
			READ;
		}
}

/*----------------------------------------------------------------------------*/
func1_simulate_status_limit                 LIKE VARIABLE   func1_simulate_status_quality
{
    REDEFINE LABEL      "Simulation value status (limit)"
                        "|de|Simulationswert Status (Limit)";
    REDEFINE TYPE       ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        STATUS_LIMIT
    }
    REDEFINE HELP "Contains status messages about limit violations."
                  "|de|Enthlt Statusmeldungen ber Grenzwertverletzungen.";
}

/*----------------------------------------------------------------------------*/
VARIABLE func1_increase_close
{
    LABEL       [func_ao_increase_close];
    HELP        [func_ao_increase_close_help];
    CLASS       DEVICE & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        {   0,  [func_ao_increase_close_RISING]     },
        {   1,  [func_ao_increase_close_FALLING]    }
    }
    HANDLING    READ & WRITE;
}


/*----------------------------------------------------------------------------*/
VARIABLE func1_out_value
{
    LABEL       [func_out_value];
    HELP        [func_ao_out_value_help];
    CLASS       DEVICE & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT "3.1f";
        DEFAULT_VALUE   0.0;
    }
    HANDLING
/*        IF ((func1_target_mode == BLOCK_MODE_MAN) || (func1_target_mode == BLOCK_MODE_LOCAL_OVERRIDE)) */
        IF (func1_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE
        {
            READ;
        }
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_out_status_quality
{
    LABEL "Output status (quality)" "|de|Ausgang Status (Qualitt)";
    HELP        [func_out_status_help];
    CLASS       DEVICE & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        STATUS_BAD_UNCERTAIN_GOOD_MASK
    }
    HANDLING
        IF ((func1_target_mode == BLOCK_MODE_MAN) || (func1_target_mode == BLOCK_MODE_LOCAL_OVERRIDE))
        {
            READ & WRITE;
        }
        ELSE
        {
            READ;
        }
}
/*----------------------------------------------------------------------------*/
func1_out_status_limit                      LIKE VARIABLE   func1_out_status_quality
{
    REDEFINE LABEL "Output status (limit)" "|de|Ausgang Status (Limit)";
    REDEFINE TYPE       ENUMERATED (1)
    {
        STATUS_LIMIT
    }
    REDEFINE HELP "Contains status messages about limit violations."
                  "|de|Enthlt Statusmeldungen ber Grenzwertverletzungen.";
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_out_upper_range_value
{
    LABEL "Reference var. range - output scaling end"
          "|de|Fhrungsgrenbereich - Ausgangsskalierung Ende";
    HELP        [func_out_scale_upper_value_help];
    CLASS       DEVICE;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT    ".1f";
        DEFAULT_VALUE 100.0;
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_out_lower_range_value
{
    LABEL "Reference var. range - output scaling start"
          "|de|Fhrungsgrenbereich - Ausgangsskalierung Anfang";
    HELP        [func_out_scale_lower_value_help];
    CLASS       DEVICE;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT   ".1f";
        DEFAULT_VALUE 0.0;
    }
    HANDLING    READ & WRITE;
}
/*----------------------------------------------------------------------------*/
VARIABLE func1_out_unit
{
    LABEL "Reference var. range - output scaling unit"
          "|de|Fhrungsgrenbereich - Ausgangsskalierung Einheit";
    HELP        [func_out_scale_unit_help];
    CLASS       DEVICE;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE   1342;
        UNIT_LIST
    }
    HANDLING    READ & WRITE;
}

/*----------------------------------------------------------------------------*/
func1_out_decimal_point                     LIKE VARIABLE   func1_pv_decimal_point
{
}


/*----------------------------------------------------------------------------*/
/* Transducer Block                                                           */
/*----------------------------------------------------------------------------*/


COMMAND read_trans1_blk
{
    SLOT 1;
    INDEX 80;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_blk_reserve, trans1_blk_object, trans1_blk_parent_class, trans1_blk_class,
            trans1_blk_dd_reference, trans1_blk_dd_rev, trans1_blk_profile, trans1_blk_profile_rev,
            trans1_blk_execution_time, trans1_blk_num_parameters, trans1_blk_index_view_1,
            trans1_blk_num_view_lists
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_st_rev
{
    SLOT 1;
    INDEX 81;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_st_rev
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_tag_desc
{
    SLOT 1;
    INDEX 82;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tag_desc
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_tag_desc
{
    SLOT 1;
    INDEX 82;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tag_desc
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_strategy
{
    SLOT 1;
    INDEX 83;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_strategy
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_strategy
{
    SLOT 1;
    INDEX 83;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_strategy
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_alert_key
{
    SLOT 1;
    INDEX 84;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_alert_key
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_alert_key
{
    SLOT 1;
    INDEX 84;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_alert_key
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_target_mode
{
    SLOT 1;
    INDEX 85;
    OPERATION  READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_target_mode
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_target_mode
{
    SLOT 1;
    INDEX 85;
    OPERATION  WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_target_mode
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_mode
{
    SLOT 1;
    INDEX 86;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans1_actual_mode, trans1_permitted_mode, trans1_normal_mode
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_alarm
{
    SLOT 1;
    INDEX 87;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_current_state_alarm_sum, trans1_unacknowledged_state_alarm_sum,
            trans1_unreported_state_alarm_sum, trans1_disabled_state_alarm_sum
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_act_stroke_time_dec
{
    SLOT 1;
    INDEX 89;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_act_stroke_time_dec
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_act_stroke_time_inc
{
    SLOT 1;
    INDEX 90;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_act_stroke_time_inc
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_device_calib_date
{
    SLOT 1;
    INDEX 103;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_device_calib_date
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_device_calib_date
{
    SLOT 1;
    INDEX 103;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_device_calib_date
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_device_config_date
{
    SLOT 1;
    INDEX 104;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_device_config_date
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_device_config_date
{
    SLOT 1;
    INDEX 104;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_device_config_date
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_lin_type
{
    SLOT 1;
    INDEX 105;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_lin_type
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_lin_type
{
    SLOT 1;
    INDEX 105;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_lin_type
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_rated_travel
{
    SLOT 1;
    INDEX 112;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_rated_travel
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_rated_travel
{
    SLOT 1;
    INDEX 112;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_rated_travel
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_self_calibration_cmd
{
    SLOT 1;
    INDEX 113;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_self_calibration_cmd
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_self_calibration_status
{
    SLOT 1;
    INDEX 114;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_self_calibration_status
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_servo_gain_1
{
    SLOT 1;
    INDEX 115;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_servo_gain_1
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_servo_gain_1
{
    SLOT 1;
    INDEX 115;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_servo_gain_1
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_servo_rate_1
{
    SLOT 1;
    INDEX 116;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_servo_rate_1
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_servo_rate_1
{
    SLOT 1;
    INDEX 116;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_servo_rate_1
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_setp_cutoff_dec
{
    SLOT 1;
    INDEX 118;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_setp_cutoff_dec
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_setp_cutoff_dec
{
    SLOT 1;
    INDEX 118;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_setp_cutoff_dec
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_setp_cutoff_inc
{
    SLOT 1;
    INDEX 119;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_setp_cutoff_inc
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_setp_cutoff_inc
{
    SLOT 1;
    INDEX 119;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_setp_cutoff_inc
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_total_valve_travel
{
    SLOT 1;
    INDEX 125;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_total_valve_travel
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_total_valve_travel
{
    SLOT 1;
    INDEX 125;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_total_valve_travel
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_total_valve_travel_limit
{
    SLOT 1;
    INDEX 126;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_total_valve_travel_limit
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_total_valve_travel_limit
{
    SLOT 1;
    INDEX 126;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_total_valve_travel_limit
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_travel_limit_low
{
    SLOT 1;
    INDEX 127;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_travel_limit_lower_value
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_travel_limit_low
{
    SLOT 1;
    INDEX 127;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_travel_limit_lower_value
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_travel_limit_upper
{
    SLOT 1;
    INDEX 128;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_travel_limit_upper_value
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_travel_limit_upper
{
    SLOT 1;
    INDEX 128;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_travel_limit_upper_value
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_travel_rate_dec
{
    SLOT 1;
    INDEX 129;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_travel_rate_dec
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_travel_rate_dec
{
    SLOT 1;
    INDEX 129;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_travel_rate_dec
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_travel_rate_inc
{
    SLOT 1;
    INDEX 130;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_travel_rate_inc
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_travel_rate_inc
{
    SLOT 1;
    INDEX 130;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_travel_rate_inc
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_valve_maintenance_date
{
    SLOT 1;
    INDEX 131;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_valve_maintenance_date
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_valve_maintenance_date
{
    SLOT 1;
    INDEX 131;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_valve_maintenance_date
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_positioning
{
    SLOT 1;
    INDEX 137;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_positioning_value,
            trans1_positioning_quality   <0xFC>,
            trans1_positioning_limit <0x03>

        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_feedback
{
    SLOT 1;
    INDEX 138;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_feedback_value,
            trans1_feedback_quality   <0xFC>,
            trans1_feedback_limit <0x03>
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_valve_man
{
    SLOT 1;
    INDEX 139;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_valve_man
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_valve_man
{
    SLOT 1;
    INDEX 139;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_valve_man
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_actuator_man
{
    SLOT 1;
    INDEX 140;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_actuator_man
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_actuator_man
{
    SLOT 1;
    INDEX 140;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_actuator_man
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_valve_type
{
    SLOT 1;
    INDEX 141;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_valve_type
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_valve_type
{
    SLOT 1;
    INDEX 141;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_valve_type
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_actuator_type
{
    SLOT 1;
    INDEX 142;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_actuator_type
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_actuator_action
{
    SLOT 1;
    INDEX 143;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_actuator_action
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_actuator_action
{
    SLOT 1;
    INDEX 143;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_actuator_action
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_valve_serial_number
{
    SLOT 1;
    INDEX 144;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_valve_serial_number
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_valve_serial_number
{
    SLOT 1;
    INDEX 144;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_valve_serial_number
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_actuator_serial_number
{
    SLOT 1;
    INDEX 145;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_actuator_serial_number
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_actuator_serial_number
{
    SLOT 1;
    INDEX 145;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_actuator_serial_number
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_additional_gear_ser_number
{
    SLOT 1;
    INDEX 146;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_additional_gear_ser_number
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_additional_gear_ser_number
{
    SLOT 1;
    INDEX 146;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_additional_gear_ser_number
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_additional_gear_man
{
    SLOT 1;
    INDEX 147;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_additional_gear_man
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_additional_gear_man
{
    SLOT 1;
    INDEX 147;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_additional_gear_man
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_additional_gear_id
{
    SLOT 1;
    INDEX 148;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_additional_gear_id
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_additional_gear_id
{
    SLOT 1;
    INDEX 148;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_additional_gear_id
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_additional_gear_install_date
{
    SLOT 1;
    INDEX 149;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_additional_gear_install_date
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_additional_gear_install_date
{
    SLOT 1;
    INDEX 149;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_additional_gear_install_date
        }
        REPLY
        {
        }
    }
}




/*----------------------------------------------------------------------------*/
COMMAND read_trans1_transm_pin_pos
{
    SLOT 1;
    INDEX 160;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_transm_pin_pos
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_transm_pin_pos
{
    SLOT 1;
    INDEX 160;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_transm_pin_pos
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_init_method
{
    SLOT 1;
    INDEX 161;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_init_method
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_init_method
{
    SLOT 1;
    INDEX 161;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_init_method
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_sub_mode_init
{
    SLOT 1;
    INDEX 162;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_sub_mode_init
        }
    }
}

/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_device_init_state
{
    SLOT 1;
    INDEX 163;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_device_init_state
        }
    }
}


/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_moving_direction
{
    SLOT 1;
    INDEX 164;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_moving_direction
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_moving_direction
{
    SLOT 1;
    INDEX 164;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_moving_direction
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_closing_direction
{
    SLOT 1;
    INDEX 165;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_closing_direction
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_closing_direction
{
    SLOT 1;
    INDEX 165;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_closing_direction
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_blocking_position
{
    SLOT 1;
    INDEX 166;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_blocking_position
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_blocking_position
{
    SLOT 1;
    INDEX 166;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_blocking_position
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_travel_lower_limit_on
{
    SLOT 1;
    INDEX 168;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_travel_lower_limit_on
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_travel_lower_limit_on
{
    SLOT 1;
    INDEX 168;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_travel_lower_limit_on
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_travel_upper_limit_on
{
    SLOT 1;
    INDEX 169;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_travel_upper_limit_on
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_travel_upper_limit_on
{
    SLOT 1;
    INDEX 169;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_travel_upper_limit_on
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_final_value_cutoff_hi_on
{
    SLOT 1;
    INDEX 170;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_final_value_cutoff_hi_on
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_final_value_cutoff_hi_on
{
    SLOT 1;
    INDEX 170;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_final_value_cutoff_hi_on
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_final_value_cutoff_lo_on
{
    SLOT 1;
    INDEX 171;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_final_value_cutoff_lo_on
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_final_value_cutoff_lo_on
{
    SLOT 1;
    INDEX 171;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_final_value_cutoff_lo_on
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_transducer_state
{
    SLOT 1;
    INDEX 172;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_transducer_state
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_charact_type
{
    SLOT 1;
    INDEX 173;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_charact_type
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_charact_type
{
    SLOT 1;
    INDEX 173;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_charact_type
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/

COMMAND read_trans1_signal_pressure_action
{
    SLOT 1;
    INDEX 176;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_signal_pressure_action
        }
    }
}


/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_pressure_limit
{
    SLOT 1;
    INDEX 177;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_pressure_limit
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_pressure_limit
{
    SLOT 1;
    INDEX 177;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_pressure_limit
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_set_fail_safe_pos
{
    SLOT 1;
    INDEX 178;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_set_fail_safe_pos
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_set_fail_safe_pos
{
    SLOT 1;
    INDEX 178;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_set_fail_safe_pos
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_final_value_range
{
    SLOT 1;
    INDEX 179;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_final_value_range_end,
            trans1_final_value_range_start,
            trans1_final_value_range_units,
            trans1_final_value_range_dec_point
        }
    }
}

COMMAND write_trans1_final_value_range
{
    SLOT 1;
    INDEX 179;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_final_value_range_end,
            trans1_final_value_range_start,
            trans1_final_value_range_units,
            trans1_final_value_range_dec_point
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_tolerance_band
{
    SLOT 1;
    INDEX 180;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tolerance_band
        }
    }
}


COMMAND write_trans1_tolerance_band
{
    SLOT 1;
    INDEX 180;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tolerance_band
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_delay_time
{
    SLOT 1;
    INDEX 181;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_delay_time
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_delay_time
{
    SLOT 1;
    INDEX 181;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_delay_time
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_status_solenoid_valve
{
    SLOT 1;
    INDEX 182;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_status_solenoid_valve
        }
    }
}

/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_final_position_value__value
{
    SLOT 1;
    INDEX 183;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_final_position_value__value,
            trans1_final_position_value__quality <0xFC>,
            trans1_final_position_value__limit   <0x03>
        }
    }
}


/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
COMMAND read_trans1_final_value__value
{
    SLOT 1;
    INDEX 184;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_final_value__value,
            trans1_final_value__quality <0xFC>,
			      trans1_final_value__limit <0x03>
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_final_value__value
{
    SLOT 1;
    INDEX 184;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_final_value__value,
            trans1_final_value__quality <0xFC>,
			      trans1_final_value__limit <0x03>
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_device_charact
{
    SLOT 1;
    INDEX 202;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_actuator_size,
            trans1_actuator_version,
            trans1_attachment,
            trans1_pressure_range_start,
            trans1_pressure_range_end,
            trans1_supply_pressure,
            trans1_booster,
            trans1_stuffing_box,
            trans1_sealing_edge,
            trans1_pressure_balancing,
            trans1_flow_characteristic,
            trans1_flow_direction,
            trans1_nom_diameter,
            trans1_nom_diameter_dn,
            trans1_kvs_unit,
            trans1_kvs_value,
            trans1_seat_diam_valve
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_trans1_device_charact
{
    SLOT 1;
    INDEX 202;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_actuator_size,
            trans1_actuator_version,
            trans1_attachment,
            trans1_pressure_range_start,
            trans1_pressure_range_end,
            trans1_supply_pressure,
            trans1_booster,
            trans1_stuffing_box,
            trans1_sealing_edge,
            trans1_pressure_balancing,
            trans1_flow_characteristic,
            trans1_flow_direction,
            trans1_nom_diameter,
            trans1_nom_diameter_dn,
            trans1_kvs_unit,
            trans1_kvs_value,
            trans1_seat_diam_valve
        }
        REPLY
        {
        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND read_trans1_user_charact
{
    SLOT 1;
    INDEX 203;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_X0,
            trans1_Y0,
            trans1_X1,
            trans1_Y1,
            trans1_X2,
            trans1_Y2,
            trans1_X3,
            trans1_Y3,
            trans1_X4,
            trans1_Y4,
            trans1_X5,
            trans1_Y5,
            trans1_X6,
            trans1_Y6,
            trans1_X7,
            trans1_Y7,
            trans1_X8,
            trans1_Y8,
            trans1_X9,
            trans1_Y9,
            trans1_X10,
            trans1_Y10

        }
    }
}

/*----------------------------------------------------------------------------*/
COMMAND write_trans1_user_charact
{
    SLOT 1;
    INDEX 203;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_X0,
            trans1_Y0,
            trans1_X1,
            trans1_Y1,
            trans1_X2,
            trans1_Y2,
            trans1_X3,
            trans1_Y3,
            trans1_X4,
            trans1_Y4,
            trans1_X5,
            trans1_Y5,
            trans1_X6,
            trans1_Y6,
            trans1_X7,
            trans1_Y7,
            trans1_X8,
            trans1_Y8,
            trans1_X9,
            trans1_Y9,
            trans1_X10,
            trans1_Y10
        }
        REPLY
        {
        }
    }
}



COMMAND write_trans1_manufac_actuator_size
{
   SLOT 1;
   INDEX 209;
   OPERATION WRITE;
   TRANSACTION
   {
        REQUEST
        {
           trans1_manufac_actuator_size
        }
        REPLY
        {
        }
   }
}

COMMAND read_trans1_manufac_actuator_size
{
   SLOT 1;
   INDEX 209;
   OPERATION READ;
   TRANSACTION
   {
        REQUEST
        {

        }
        REPLY
        {
          trans1_manufac_actuator_size
        }
   }
}


/*----------------------------------------------------------------------------*/
/* Function Block                                                             */
/*----------------------------------------------------------------------------*/
COMMAND read_func1_blk
{
    BLOCK function_block_1;
    INDEX 0;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_blk_reserve, func1_blk_object, func1_blk_parent_class, func1_blk_class,
            func1_blk_dd_reference, func1_blk_dd_rev, func1_blk_profile, func1_blk_profile_rev,
            func1_blk_execution_time, func1_blk_num_parameters, func1_blk_index_view_1,
            func1_blk_num_view_lists
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_st_rev
{
    BLOCK function_block_1;
    INDEX 1;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_st_rev
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_tag_desc
{
    BLOCK function_block_1;
    INDEX 2;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_tag_desc
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_tag_desc
{
    BLOCK function_block_1;
    INDEX 2;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_tag_desc
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_strategy
{
    BLOCK function_block_1;
    INDEX 3;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_strategy
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_strategy
{
    BLOCK function_block_1;
    INDEX 3;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_strategy
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_alert_key
{
    BLOCK function_block_1;
    INDEX 4;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_alert_key
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_alert_key
{
    BLOCK function_block_1;
    INDEX 4;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_alert_key
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_target_mode
{
    BLOCK function_block_1;
    INDEX 5;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_target_mode
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_target_mode
{
    BLOCK function_block_1;
    INDEX 5;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_target_mode
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_mode
{
    BLOCK function_block_1;
    INDEX 6;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             func1_actual_mode, func1_permitted_mode, func1_normal_mode
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_alarm
{
    BLOCK function_block_1;
    INDEX 7;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_current_state_alarm_sum, func1_unacknowledged_state_alarm_sum,
            func1_unreported_state_alarm_sum, func1_disabled_state_alarm_sum
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_batch_information
{
    BLOCK function_block_1;
    INDEX 8;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_batch_id,
            func1_batch_unit,
            func1_batch_operation,
            func1_batch_phase
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_batch_information
{
    BLOCK function_block_1;
    INDEX 8;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_batch_id,
            func1_batch_unit,
            func1_batch_operation,
            func1_batch_phase
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_setpoint
{
    BLOCK function_block_1;
    INDEX 9;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_setpoint_value,
            func1_setpoint_status           <0xFC>,
            func1_setpoint_status_limit     <0x03>
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_setpoint
{
    BLOCK function_block_1;
    INDEX 9;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_setpoint_value,
            func1_setpoint_status           <0xFC>,
            func1_setpoint_status_limit     <0x03>
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_pv
{
    BLOCK function_block_1;
    INDEX 11;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_pv_upper_range_value,
            func1_pv_lower_range_value,
            func1_pv_unit,
            func1_pv_decimal_point
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_pv
{
    BLOCK function_block_1;
    INDEX 11;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_pv_upper_range_value,
            func1_pv_lower_range_value,
            func1_pv_unit,
            func1_pv_decimal_point
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_readback
{
    BLOCK function_block_1;
    INDEX 12;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_readback_value,
            func1_readback_status           <0xFC>,
            func1_readback_status_limit     <0x03>
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_rcas_in
{
    BLOCK function_block_1;
    INDEX 14;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_rcas_in_value,
            func1_rcas_in_status   <0xFC>
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_rcas_in
{
    BLOCK function_block_1;
    INDEX 14;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_rcas_in_value,
            func1_rcas_in_status   <0xFC>
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_in_channel
{
    BLOCK function_block_1;
    INDEX 21;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_in_channel
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_in_channel
{
    BLOCK function_block_1;
    INDEX 21;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_in_channel
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_out_channel
{
    BLOCK function_block_1;
    INDEX 22;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_out_channel
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_out_channel
{
    BLOCK function_block_1;
    INDEX 22;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_out_channel
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_fsafe_time
{
    BLOCK function_block_1;
    INDEX 23;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_fsafe_time
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_fsafe_time
{
    BLOCK function_block_1;
    INDEX 23;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_fsafe_time
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_fsafe_type
{
    BLOCK function_block_1;
    INDEX 24;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_fsafe_type
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_fsafe_type
{
    BLOCK function_block_1;
    INDEX 24;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_fsafe_type
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_fsafe_value
{
    BLOCK function_block_1;
    INDEX 25;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_fsafe_value
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_fsafe_value
{
    BLOCK function_block_1;
    INDEX 25;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_fsafe_value
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_rcas_out
{
    BLOCK function_block_1;
    INDEX 27;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_rcas_out_value,
            func1_rcas_out_status_quality   <0xFC>,
            func1_rcas_out_status_limit     <0x03>
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_current_position
{
    BLOCK function_block_1;
    INDEX 31;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_position_discrete_value,
            func1_position_discrete_status   <0xFC>
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_setpoint_deviation
{
    BLOCK function_block_1;
    INDEX 32;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_setpoint_deviation
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_check_back
{
    BLOCK function_block_1;
    INDEX 33;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_check_back
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_check_back_mask
{
    BLOCK function_block_1;
    INDEX 34;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_check_back_mask
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_check_back_opt
{
    BLOCK function_block_1;
    INDEX 49;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
           func1_check_back_opt
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_check_back_opt
{
    BLOCK function_block_1;
    INDEX 49;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
           func1_check_back_opt
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_simulate
{
    BLOCK function_block_1;
    INDEX 35;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_simulate_status_quality   <0xFC>,
            func1_simulate_status_limit     <0x03>,
            func1_simulate_value,
            func1_simulate_enabled
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_simulate
{
    BLOCK function_block_1;
    INDEX 35;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_simulate_status_quality   <0xFC>,
            func1_simulate_status_limit     <0x03>,
            func1_simulate_value,
            func1_simulate_enabled
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_increase_close
{
    BLOCK function_block_1;
    INDEX 36;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_increase_close
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_increase_close
{
    BLOCK function_block_1;
    INDEX 36;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_increase_close
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_out
{
    BLOCK function_block_1;
    INDEX 37;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_out_value,
            func1_out_status_quality    <0xFC>,
            func1_out_status_limit      <0x03>
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_out
{
    BLOCK function_block_1;
    INDEX 37;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_out_value,
            func1_out_status_quality    <0xFC>,
            func1_out_status_limit      <0x03>
        }
        REPLY
        {
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND read_func1_out_scale
{
    BLOCK function_block_1;
    INDEX 38;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_out_upper_range_value, func1_out_lower_range_value,
            func1_out_unit, func1_out_decimal_point
        }
    }
}
/*----------------------------------------------------------------------------*/
COMMAND write_func1_out_scale
{
    BLOCK function_block_1;
    INDEX 38;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_out_upper_range_value, func1_out_lower_range_value,
            func1_out_unit, func1_out_decimal_point
        }
        REPLY
        {
        }
    }
}

