/*--------------------------------------------------------------*/
/*  Copyright (C)   SAMSON AG (2005). All Rights Reserved       */
/*  Product:        SIEMENS SIMATIC PDM                         */
/*  Device:         SAMSON PROFIBUS Positioner 373X-4           */
/*  Communication:  PROFIBUS PA/DPV1 Profil 3.01                */
/*  Dictionary:     SIPADC01.dct                                */
/*  Description:    Device Description                          */
/*            			DI2									    */
/*  $Revision:   1.3  $                                         */
/*  $Date:   31 May 2005 $					                    */
/*--------------------------------------------------------------*/
/* Datum:     Autor:  Aenderungen:                              */
/* ------     ------  ------------                              */
/* 31.05.2005 Jung/E7 erstellt									*/
/* 13.07.2005 Ald/E7  erweitert     							*/
/*                                                              */
/*                                                              */
/*--------------------------------------------------------------*/

#define DEFAULT_VALUE_trans2_blk_parent_class		6

BLOCK transducer_block_3
{
	TYPE	TRANSDUCER;
	NUMBER	3;
}


/* -- Index 0: blk_object*/

COMMAND read_trans3_blk
{
	SLOT 3;
	INDEX 60;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans3_blk_reserve, trans3_blk_object, trans3_blk_parent_class, trans3_blk_class,
			trans3_blk_dd_reference, trans3_blk_dd_rev, trans3_blk_profile, trans3_blk_profile_rev,
			trans3_blk_execution_time, trans3_blk_num_parameters, trans3_blk_index_view_1,
			trans3_blk_num_view_lists
		}
	}
}

VARIABLE trans3_blk_reserve
{
	LABEL		[blk_reserved];
	HELP		[blk_reserved_help];
	CLASS		DEVICE;
	TYPE		UNSIGNED_INTEGER(1);
	HANDLING	READ;
}

VARIABLE trans3_blk_object
{
	LABEL		[blk_block_object];
	HELP		[blk_block_object_help];
	CLASS		DEVICE;
	TYPE		ENUMERATED(1)
	{
		{	3,	[blk_block_object_TRANSDUCER]		}
	}
	HANDLING	READ;
}

VARIABLE trans3_blk_parent_class
{
	LABEL		[blk_parent_class];
	HELP		[trans_blk_parent_class_help];
	CLASS		DEVICE;
	TYPE		ENUMERATED(1)
	{
	  {	6,	[trans_blk_parent_class_BIN_IO]	},
		{	252,	[unknown]					}
	}
	HANDLING	READ;
}

VARIABLE trans3_blk_class
{
	LABEL		[blk_class];
	HELP		[trans_blk_class_help];
	CLASS		DEVICE;
	TYPE		ENUMERATED(1)
	{
		 {	1,		[trans_bin_blk_class_BIN_IN]		},
		 {	250,	[not_used] 					},
		 {	251,	[none]						},
		 {	252,	[unknown]					},
		 {	253,	[special]					}
	}
	HANDLING	READ;
}

VARIABLE trans3_blk_dd_reference
{
	LABEL		[blk_dd_reference];
	HELP		[blk_dd_reference_help];
	CLASS		DEVICE;
	TYPE		UNSIGNED_INTEGER (4);
	HANDLING	READ;
}

VARIABLE trans3_blk_dd_rev
{
	LABEL		[blk_dd_rev];
	HELP		[blk_dd_rev_help];
	CLASS		DEVICE;
	TYPE		UNSIGNED_INTEGER(2);
	HANDLING	READ;
}

VARIABLE trans3_blk_profile
{
	LABEL		[blk_profile];
	HELP		[blk_profile_help];
	CLASS		DEVICE;
	TYPE		ENUMERATED (2)
	{
		DEFAULT_VALUE	0x4002;
		{ 0x4001,	[blk_profile_PA_COMPACT_A]	},
		{ 0x4002,	[blk_profile_PA_COMPACT_B]	},
		{ 0x4081,	[blk_profile_PA_SIMPLE_A]	},
		{ 0x4082,	[blk_profile_PA_SIMPLE_B]	}
	}
	HANDLING	READ;
}

VARIABLE trans3_blk_profile_rev
{
	LABEL		[blk_profile_rev];
	HELP		[blk_profile_rev_help];
	CLASS		DEVICE;
	TYPE		ENUMERATED (2)
	{
  #ifdef PROFILE_REV
		DEFAULT_VALUE 0x0301;
  #endif

		{	0x0300,	"3.0"	},
		{	0x0301,	"3.01"	}

	}
	HANDLING	READ;
}

VARIABLE trans3_blk_execution_time
{
	LABEL		[blk_execution_time];
	HELP		[blk_execution_time_help];
	CLASS		DEVICE;
	TYPE		UNSIGNED_INTEGER (1);
	HANDLING	READ;

}

VARIABLE trans3_blk_num_parameters
{
	LABEL		[blk_num_parameters];
	HELP		[blk_num_parameters_help];
	CLASS		DEVICE;
	TYPE		UNSIGNED_INTEGER (2);
	HANDLING	READ;
}

VARIABLE trans3_blk_index_view_1
{
	LABEL		[blk_index_view_1];
	HELP		[blk_index_view_1_help];
	CLASS		DEVICE;
	TYPE		UNSIGNED_INTEGER (2);
	HANDLING	READ;
}

VARIABLE trans3_blk_num_view_lists
{
	LABEL		[blk_num_view_lists];
	HELP		[blk_num_view_lists_help];
	CLASS		DEVICE;
	TYPE		UNSIGNED_INTEGER (1);
	HANDLING	READ;
}



/* -- Index 1: st_rev*/

VARIABLE trans3_st_rev
{
	LABEL		[st_rev];
	HELP		[st_rev_help];
	CLASS		DEVICE;
	TYPE		UNSIGNED_INTEGER (2)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ;
}

COMMAND read_trans3_st_rev
{
	SLOT 3;
	INDEX 61;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans3_st_rev
		}
	}
}

/* -- Index 2: tag_desc*/

VARIABLE trans3_tag_desc
{
	LABEL		[tag_desc];
	HELP		[tag_desc_help];
	CLASS		DEVICE;
	TYPE		ASCII (32);
	HANDLING	READ & WRITE;
}

COMMAND read_trans3_tag_desc
{
	SLOT 3;
	INDEX 62;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans3_tag_desc
		}
	}
}

COMMAND write_trans3_tag_desc
{
	SLOT 3;
	INDEX 62;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans3_tag_desc
		}
		REPLY
		{
		}
	}
}


/* -- Index 3: strategy*/

VARIABLE trans3_strategy
{
	LABEL		[strategy];
	HELP		[strategy_help];
	CLASS		DEVICE;
	TYPE		UNSIGNED_INTEGER (2)
    {
            DEFAULT_VALUE   0;
    }
	HANDLING	READ & WRITE;
}

COMMAND read_trans3_strategy
{
	SLOT 3;
	INDEX 63;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans3_strategy
		}
	}
}

COMMAND write_trans3_strategy
{
	SLOT 3;
	INDEX 63;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans3_strategy
		}
		REPLY
		{
		}
	}
}


/* -- Index 4: alert key*/

VARIABLE trans3_alert_key
{
	LABEL		[alert_key];
	HELP		[alert_key_help];
	CLASS		DEVICE;
	TYPE		UNSIGNED_INTEGER (1)
    {
            DEFAULT_VALUE   0;
    }
	HANDLING	READ & WRITE;
}

COMMAND read_trans3_alert_key
{
	SLOT 3;
	INDEX 64;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans3_alert_key
		}
	}
}

COMMAND write_trans3_alert_key
{
	SLOT 3;
	INDEX 64;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans3_alert_key
		}
		REPLY
		{
		}
	}
}


/* Index 5: target_mode*/

VARIABLE trans3_target_mode
{
	LABEL		[target_mode];
	HELP		[target_mode_help];
	CLASS		DEVICE;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0x08;
		{	0x08,	[mode_AUTO]				},
		{	0x80, [mode_OUT_OF_SERVICE]	}
	}
	HANDLING	READ & WRITE;
}

COMMAND read_trans3_target_mode
{
	SLOT 3;
	INDEX 65;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans3_target_mode
		}
	}
}

COMMAND write_trans3_target_mode
{
	SLOT 3;
	INDEX 65;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans3_target_mode
		}
		REPLY
		{
		}
	}
}

/* -- Index 6: mode*/

VARIABLE trans3_actual_mode
{
	LABEL		[actual_mode];
	HELP		[actual_mode_help];
	CLASS		DEVICE & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0x08;
		{	0x08,	[mode_AUTO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
	HANDLING	READ;
}

VARIABLE trans3_permitted_mode
{
	LABEL		[permitted_mode];
	HELP		[permitted_mode_help];
	CLASS		DEVICE;
	TYPE		BIT_ENUMERATED (1)
	{
		DEFAULT_VALUE	0x08;
		{	0x08,	[mode_AUTO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
	HANDLING	READ;
}

VARIABLE trans3_normal_mode
{
	LABEL		[normal_mode];
	HELP		[normal_mode_help];
	CLASS		DEVICE;
	TYPE		ENUMERATED (1)
	{
		{	0x08,	[mode_AUTO]				}
	}
	HANDLING	READ;
}

COMMAND read_trans3_mode
{
	SLOT 3;
	INDEX 66;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			 trans3_actual_mode, trans3_permitted_mode, trans3_normal_mode
		}
	}
}


/* -- Index 7*/

COMMAND read_trans3_alarm
{
	SLOT 3;
	INDEX 67;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans3_current_state_alarm_sum, trans3_unacknowledged_state_alarm_sum,
			trans3_unreported_state_alarm_sum, trans3_disabled_state_alarm_sum
		}
	}
}

VARIABLE trans3_current_state_alarm_sum
{
	LABEL		[current_state_alarm_sum];
	HELP		[current_state_alarm_sum_help];
	CLASS		DEVICE & DYNAMIC;
	TYPE		BIT_ENUMERATED (2)
	{
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x8000,	[limit_state_ST_REV]	}
	}
	HANDLING	READ;
}

VARIABLE trans3_unacknowledged_state_alarm_sum
{
	LABEL		[unacknowledged_state_alarm_sum];
	HELP		[unacknowledged_state_alarm_sum_help];
	CLASS		DEVICE & DYNAMIC;
	TYPE		BIT_ENUMERATED (2)
	{
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x8000,	[limit_state_ST_REV]	}
	}
	HANDLING	READ;
}

VARIABLE trans3_unreported_state_alarm_sum
{
	LABEL		[unreported_state_alarm_sum];
	HELP		[unreported_state_alarm_sum_help];
	CLASS		DEVICE & DYNAMIC;
	TYPE		BIT_ENUMERATED (2)
	{
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x8000,	[limit_state_ST_REV]	}
	}
	HANDLING	READ;
}

VARIABLE trans3_disabled_state_alarm_sum
{
	LABEL		[disabled_state_alarm_sum];
	HELP		[disabled_state_alarm_sum_help];
	CLASS		DEVICE & DYNAMIC;
	TYPE		BIT_ENUMERATED (2)
	{
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x8000,	[limit_state_ST_REV]	}
	}
	HANDLING	READ;
}

/* --- Index 10: sensor_ID*/

VARIABLE trans3_sensor_id
{

	LABEL		[phys_device_product_code];
	HELP		[phys_device_product_code_help];
	CLASS		DEVICE;
	TYPE		ASCII(16);

	HANDLING	READ & WRITE;
}

COMMAND read_trans3_sensor_id
{
	SLOT 3;
	INDEX 69;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans3_sensor_id
		}
	}
}

COMMAND write_trans3_sensor_id
{
	SLOT 3;
	INDEX 69;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans3_sensor_id
		}
		REPLY
		{
		}
	}
}

/* --- Index 10: sensor_ser_num*/

VARIABLE trans3_sensor_ser_num
{

	LABEL		[trans_pres_sensor_serial_num];
	HELP		[trans_pres_sensor_serial_num_help];
	CLASS		DEVICE;
	TYPE		ASCII(16);

	HANDLING	READ & WRITE;
}

COMMAND read_trans3_sensor_ser_num
{
	SLOT 3;
	INDEX 70;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans3_sensor_ser_num
		}
	}
}

COMMAND write_trans3_sensor_ser_num
{
	SLOT 3;
	INDEX 70;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans3_sensor_ser_num
		}
		REPLY
		{
		}
	}
}

/* --- Index 11: sensor_man*/

VARIABLE trans3_sensor_man
{
	LABEL		[phys_device_man_id];
	HELP		[phys_device_man_id_help];
	CLASS		DEVICE;
	TYPE		ASCII (16);
	HANDLING	READ & WRITE;
}

COMMAND read_trans3_sensor_man
{
	SLOT 3;
	INDEX 71;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans3_sensor_man
		}
	}
}

COMMAND write_trans3_sensor_man
{
	SLOT 3;
	INDEX 71;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			trans3_sensor_man
		}
		REPLY
		{
		}
	}
}

/* --- Index 12: pv_d*/

VARIABLE trans3_DI_value
{
	LABEL		[menu_dialog_display_measure];
	HELP		[func_di_out_value_help];
	CLASS		OUTPUT & DYNAMIC;
	TYPE        UNSIGNED_INTEGER (1)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING READ;

}

VARIABLE trans3_DI_status_quality
{
	LABEL		[status_quality];
	HELP		[func_out_status_help];
	CLASS		DEVICE & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_BAD_UNCERTAIN_GOOD_MASK
	}

	HANDLING READ;

}

trans3_DI_status_limit					LIKE VARIABLE	trans3_DI_status_quality
{
	REDEFINE LABEL		[status_limit];
	REDEFINE TYPE		ENUMERATED (1)
	{
		STATUS_LIMIT
	}
  REDEFINE HELP "Contains status messages about limit violations."
                "|de|Enthlt Statusmeldungen ber Grenzwertverletzungen.";
}

COMMAND read_trans3_DI_value
{
	SLOT 3;
	INDEX 72;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			trans3_DI_value,
			trans3_DI_status_quality <0xFC>,
			trans3_DI_status_limit <0x03>
		}
	}
}


/* -------------------- DI2 FB -------------------------------------------*/


BLOCK function_block_3
{
	TYPE	FUNCTION;
	NUMBER	3 ;
}

func3_DI_blk_reserve						LIKE VARIABLE	phys_blk_reserve
{
}

VARIABLE func3_DI_blk_object
{
	LABEL		[blk_block_object];
	HELP		[blk_block_object_help];
	CLASS		DEVICE;
	TYPE		ENUMERATED(1)
	{
		{	2,	[blk_block_object_FUNCTION]		}
	}
	HANDLING	READ;
}

VARIABLE func3_DI_blk_parent_class
{
	LABEL		[blk_parent_class];
	HELP		[func_blk_parent_class_help];
	CLASS		DEVICE;
	TYPE		ENUMERATED(1)
	{
		{	1,	[func_blk_parent_class_INPUT]	}
	}
	HANDLING	READ;
}

VARIABLE func3_DI_blk_class
{
	LABEL		[blk_class];
	HELP		[func_blk_class_help];
	CLASS		DEVICE;
	TYPE		ENUMERATED(1)
	{
		{	2,		[func_blk_class_DI]		},
		{	250,	[not_used]				},
		{	251,	[none]					},
		{	252,	[unknown]				},
		{	253,	[special]				}
	}
	HANDLING	READ;
}

func3_DI_blk_dd_reference					LIKE VARIABLE	trans3_blk_dd_reference
{
}

func3_DI_blk_dd_rev							LIKE VARIABLE	trans3_blk_dd_rev
{
}

func3_DI_blk_profile						LIKE VARIABLE	trans3_blk_profile
{
}

func3_DI_blk_profile_rev					LIKE VARIABLE	trans3_blk_profile_rev
{
}

func3_DI_blk_execution_time					LIKE VARIABLE	trans3_blk_execution_time
{
}

func3_DI_blk_num_parameters					LIKE VARIABLE	trans3_blk_num_parameters
{
}

func3_DI_blk_index_view_1					LIKE VARIABLE	trans3_blk_index_view_1
{
}

func3_DI_blk_num_view_lists					LIKE VARIABLE	trans3_blk_num_view_lists
{
}

func3_DI_st_rev								LIKE VARIABLE	trans3_st_rev
{
}

func3_DI_tag_desc							LIKE VARIABLE	trans3_tag_desc
{
}

func3_DI_strategy							LIKE VARIABLE	trans3_strategy
{
}

func3_DI_alert_key							LIKE VARIABLE	trans3_alert_key
{
}

VARIABLE func3_DI_target_mode
{
	LABEL		[target_mode];
	HELP		[target_mode_help];
	CLASS		DEVICE;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	BLOCK_MODE_AUTO;
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_DI_actual_mode
{
	LABEL		[actual_mode];
	HELP		[actual_mode_help];
	CLASS		DEVICE & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	BLOCK_MODE_AUTO;
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
	HANDLING	READ;
}

VARIABLE func3_DI_permitted_mode
{
	LABEL		[permitted_mode];
	HELP		[permitted_mode_help];
	CLASS		DEVICE;
	TYPE		BIT_ENUMERATED (1)
	{
		DEFAULT_VALUE	BLOCK_MODE_AUTO;
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
	HANDLING	READ;
}

VARIABLE func3_DI_normal_mode
{
	LABEL		[normal_mode];
	HELP		[normal_mode_help];
	CLASS		DEVICE;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	BLOCK_MODE_AUTO;
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
	HANDLING	READ;
}

func3_DI_current_state_alarm_sum			LIKE VARIABLE	phys_current_state_alarm_sum
{
	REDEFINE TYPE		BIT_ENUMERATED (2)
	{
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x8000,	[limit_state_ST_REV]	}
	}

}

func3_DI_unacknowledged_state_alarm_sum		LIKE VARIABLE	phys_unacknowledged_state_alarm_sum
{
	REDEFINE TYPE		BIT_ENUMERATED (2)
	{
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x8000,	[limit_state_ST_REV]	}
	}
}

func3_DI_unreported_state_alarm_sum			LIKE VARIABLE	phys_unreported_state_alarm_sum
{
	REDEFINE TYPE		BIT_ENUMERATED (2)
	{
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x8000,	[limit_state_ST_REV]	}
	}
}

func3_DI_disabled_state_alarm_sum			LIKE VARIABLE	phys_disabled_state_alarm_sum
{
	REDEFINE TYPE		BIT_ENUMERATED (2)
	{
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x8000,	[limit_state_ST_REV]	}
	}
}

VARIABLE func3_DI_batch_id
{
	LABEL		[func_batch_id];
	HELP		[func_batch_id_help];
	CLASS		DEVICE;
	TYPE		UNSIGNED_INTEGER (4)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_DI_batch_unit
{
	LABEL		[func_batch_unit];
	HELP		[func_batch_unit_help];
	CLASS		DEVICE;
	TYPE		UNSIGNED_INTEGER (2)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_DI_batch_operation
{
	LABEL		[func_batch_operation];
	HELP		[func_batch_operation_help];
	CLASS		DEVICE;
	TYPE		UNSIGNED_INTEGER (2)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_DI_batch_phase
{
	LABEL		[func_batch_phase];
	HELP		[func_batch_phase_help];
	CLASS		DEVICE;
	TYPE		UNSIGNED_INTEGER (2)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ & WRITE;
}

/*---------------------------------------------------------------------*/
/*    Function Block: Discrete Input 1	Additional Parameter		   */
/*---------------------------------------------------------------------*/

VARIABLE func3_DI_out_value
{
	LABEL		[func_out_value];
	HELP		[func_ai_out_value_help];
	CLASS		OUTPUT & DYNAMIC;
	TYPE        UNSIGNED_INTEGER (1)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING
		IF (func3_DI_target_mode == BLOCK_MODE_MAN)
		{
			READ & WRITE;
		}
		ELSE {
			READ;
		}
}

VARIABLE func3_DI_out_status_quality
{
	LABEL		[status_quality];
	HELP		[func_out_status_help];
	CLASS		OUTPUT & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
	  STATUS_BAD_UNCERTAIN_GOOD_MASK
	}
 	POST_EDIT_ACTIONS
	{
		IF (func3_DI_target_mode == BLOCK_MODE_MAN)
		{
			method_set_status_limit_func3_DI
		}
	}
	HANDLING
	  IF (func3_DI_target_mode == BLOCK_MODE_MAN)
		{
			READ & WRITE;
		}
		ELSE {
			READ;
		}
}

func3_DI_out_status_limit					LIKE VARIABLE	func3_DI_out_status_quality
{
	REDEFINE LABEL		[status_limit];
	REDEFINE TYPE		ENUMERATED (1)
	{
		STATUS_LIMIT
	}
  REDEFINE HELP "Contains status messages about limit violations."
                "|de|Enthlt Statusmeldungen ber Grenzwertverletzungen.";
}

/*----------------------------------------------------------------------------*/
VARIABLE func3_DI_channel
{
    LABEL       [func_channel];
    HELP        [func_channel_help];
    CLASS       DEVICE;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE   780;
        {      0,  "Not active"
                   "|de|Nicht aktiv"  },
        {    780,  "Active"
                   "|de|Aktiv" }
    }
    HANDLING    READ & WRITE;
}


VARIABLE func3_DI_invert
{
   /* ST_REV */
	LABEL		[func_invert];
	HELP		[func_invert_help];
	CLASS		DEVICE;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{	0,	[func_invert_NOT_INVERT]	},
		{	1,	[func_invert_INVERT]		}
	}
	HANDLING	READ & WRITE;
}

VARIABLE func3_DI_fsafe_type /* Art der Reaktion auf Sensorausfall */
{
	/* ST_REV */
	LABEL		[func_ao_fsafe_type];
	HELP		[func_ao_fsafe_type_help_PROFILE_3];
	CLASS		DEVICE;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE    1;
		{   0,  [func_ai_fsafe_type_FAIL_SAFE_VALUE]        },
		{   1,  [func_ai_fsafe_type_STORING_LAST_SETPOINT]  },
		{   2,  "OUT_D has the wrong calculated value.Status=BAD"
	            "|de|OUT_D hat falsch berechneten Wert.Status=Schlecht" }
	}
  HANDLING	READ & WRITE;
}

VARIABLE func3_DI_fsafe_value /* Ersatzwert bei Sensorausfall */
{
   /* ST_REV */
   LABEL		[func_ai_fsafe_value] ;
   HELP			[func_ai_fsafe_value_help];
   CLASS		DEVICE;
   TYPE			UNSIGNED_INTEGER (1)
   {
      DEFAULT_VALUE    0;
      MIN_VALUE        0;
      MAX_VALUE        1;
   }
   HANDLING		READ & WRITE;
}


VARIABLE func3_DI_simulation_enabled
{
   /* ST_REV */
	LABEL		[func_simulation_enabled];
	HELP		[func_simulation_enabled_help];
	CLASS		DEVICE;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		{	0,	[disabled]		},
		{	1,	[enabled]		}
	}
	HANDLING READ & WRITE;
}

VARIABLE func3_DI_simulate_value
{
  /* ST_REV */
	LABEL		[func_simulate_value];
	HELP		[func_ai_simulate_value_help];
	CLASS		DEVICE;
	TYPE        UNSIGNED_INTEGER (1)
	{
		DEFAULT_VALUE	0;
        MIN_VALUE 0;
        MAX_VALUE 1;
	}
	HANDLING
		IF (func3_DI_simulation_enabled == 1)
		{
			READ & WRITE;
		}
		ELSE {
			READ;
		}
}

VARIABLE func3_DI_simulate_status_quality
{
/*	LABEL		[status_quality];*/
    LABEL      "Simulation value status (quality)"
               "|de|Simulationswert Status (Qualitt)";
	HELP		[func_simulate_status_help];
	CLASS		DEVICE;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0;
		STATUS_BAD_UNCERTAIN_GOOD_MASK
	}
	POST_EDIT_ACTIONS
	{
		method_set_status_limit_func3_DI
	}
	HANDLING
		IF (func3_DI_simulation_enabled == 1)
		{
			READ & WRITE;
		}
		ELSE {
			READ;
		}
}

func3_DI_simulate_status_limit				LIKE VARIABLE	func3_DI_simulate_status_quality
{
   /* ST_REV */
/*	REDEFINE LABEL		[status_limit];*/
    REDEFINE LABEL      "Simulation value status (limit)"
                        "|de|Simulationswert Status (Limit)";
	REDEFINE TYPE		ENUMERATED (1)
	{
		STATUS_LIMIT
	}
  REDEFINE HELP "Contains status messages about limit violations."
                "|de|Enthlt Statusmeldungen ber Grenzwertverletzungen.";
}


/*---------------------------------------------------------------------*/
/*    Function Block: Commands						                   */
/*---------------------------------------------------------------------*/

COMMAND read_func3_DI_blk
{
	SLOT 3;
	INDEX 16;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_DI_blk_reserve, func3_DI_blk_object, func3_DI_blk_parent_class, func3_DI_blk_class,
			func3_DI_blk_dd_reference, func3_DI_blk_dd_rev, func3_DI_blk_profile, func3_DI_blk_profile_rev,
			func3_DI_blk_execution_time, func3_DI_blk_num_parameters, func3_DI_blk_index_view_1,
			func3_DI_blk_num_view_lists
		}
	}
}

COMMAND read_func3_DI_st_rev
{
	SLOT 3;
	INDEX 17;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_DI_st_rev
		}
	}
}

COMMAND read_func3_DI_tag_desc
{
	SLOT 3;
	INDEX 18;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_DI_tag_desc
		}
	}
}

COMMAND write_func3_DI_tag_desc
{
	SLOT 3;
	INDEX 18;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_DI_tag_desc
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_DI_strategy
{
	SLOT 3;
	INDEX 19;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_DI_strategy
		}
	}
}

COMMAND write_func3_DI_strategy
{
	SLOT 3;
	INDEX 19;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_DI_strategy
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_DI_alert_key
{
	SLOT 3;
	INDEX 20;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_DI_alert_key
		}
	}
}

COMMAND write_func3_DI_alert_key
{
	SLOT 3;
	INDEX 20;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_DI_alert_key
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_DI_target_mode
{
	SLOT 3;
	INDEX 21;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_DI_target_mode
		}
	}
}

COMMAND write_func3_DI_target_mode
{
	SLOT 3;
	INDEX 21;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_DI_target_mode
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_DI_mode
{
	SLOT 3;
	INDEX 22;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			 func3_DI_actual_mode, func3_DI_permitted_mode, func3_DI_normal_mode
		}
	}
}

COMMAND read_func3_DI_alarm
{
	SLOT 3;
	INDEX 23;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_DI_current_state_alarm_sum, func3_DI_unacknowledged_state_alarm_sum,
			func3_DI_unreported_state_alarm_sum, func3_DI_disabled_state_alarm_sum
		}
	}
}

COMMAND read_func3_DI_batch_information
{
	SLOT 3;
	INDEX 24;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_DI_batch_id, func3_DI_batch_unit, func3_DI_batch_operation, func3_DI_batch_phase
		}
	}
}

COMMAND write_func3_DI_batch_information
{
	SLOT 3;
	INDEX 24;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_DI_batch_id, func3_DI_batch_unit, func3_DI_batch_operation, func3_DI_batch_phase
		}
		REPLY
		{
		}
	}
}

/*---------------------------------------------------------------------*/
/*    Function Block :  Commands	Additional Parameter	           */
/*---------------------------------------------------------------------*/
COMMAND read_func3_DI_out
{
	SLOT 3;
	INDEX 26;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_DI_out_value,
			func3_DI_out_status_quality <0xFC>,
			func3_DI_out_status_limit	<0x03>
		}
	}
}

COMMAND write_func3_DI_out
{
	SLOT 3;
	INDEX 26;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_DI_out_value,
			func3_DI_out_status_quality <0xFC>,
			func3_DI_out_status_limit	<0x03>
		}
		REPLY
		{
		}
	}
}


COMMAND read_func3_DI_channel
{
	SLOT 3;
	INDEX 30;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_DI_channel
		}
	}
}

COMMAND write_func3_DI_channel
{
	SLOT 3;
	INDEX 30;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_DI_channel
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_DI_invert
{
	SLOT 3;
	INDEX 31;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_DI_invert
		}
	}
}

COMMAND write_func3_DI_invert
{
	SLOT 3;
	INDEX 31;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_DI_invert
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_DI_fsafe_type
{
	SLOT 3;
	INDEX 36;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_DI_fsafe_type
		}
	}
}

COMMAND write_func3_DI_fsafe_type
{
	SLOT 3;
	INDEX 36;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_DI_fsafe_type
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_DI_fsafe_value
{
	SLOT 3;
	INDEX 37;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_DI_fsafe_value
		}
	}
}

COMMAND write_func3_DI_fsafe_value
{
	SLOT 3;
	INDEX 37;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_DI_fsafe_value
		}
		REPLY
		{
		}
	}
}

COMMAND read_func3_DI_simulate
{
	SLOT 3;
	INDEX 40;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_DI_simulate_status_quality  <0xFC>,
			func3_DI_simulate_status_limit		<0x03>,
			func3_DI_simulate_value,
			func3_DI_simulation_enabled
		}
	}
}

COMMAND write_func3_DI_simulate
{
	SLOT 3;
	INDEX 40;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_DI_simulate_status_quality	<0xFC>,
			func3_DI_simulate_status_limit		<0x03>,
			func3_DI_simulate_value,
			func3_DI_simulation_enabled
		}
		REPLY
		{
		}
	}
}

/*---------------------------------------------------------------------*/
/*    Function Block: Methods                                          */
/*---------------------------------------------------------------------*/

METHOD method_set_status_limit_func3_DI
{
	CLASS		INPUT;
	DEFINITION
	{
		int	quality;
		int block_mode;			/* !!! temp.: bis Methoden mit Aufrufparametern funktionieren !!! */

		quality = ivar_value(func3_DI_simulate_status_quality);
		if ((quality == 0x20) || (quality == 0x30))
			iassign(func3_DI_simulate_status_limit, 0);

		block_mode	= ivar_value(func3_DI_target_mode);
		quality		= ivar_value(func3_DI_out_status_quality);
		if ((block_mode == BLOCK_MODE_MAN) && ((quality == 0x20) || (quality == 0x30)))
			iassign(func3_DI_out_status_limit, 0);
	}
}

/***********************************************************************/
/*    Function Block  Unit Relations                                   */
/***********************************************************************/

/* Function Block : no unit relations */


/***********************************************************************/
/*    Function Block   Collections                                     */
/***********************************************************************/
/*
COLLECTION OF VARIABLE func3
{
	MEMBERS
	{
		actual_mode,		func3_DI_actual_mode,			func3_TITLE ;
		simulation_enabled, func3_DI_simulation_enabled,	func3_TITLE ;
		out,				func3_DI_out_value,			func3_TITLE ;
		simulate_value,		func3_DI_simulate_value,		func3_TITLE ;
	}
}
*/

